/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.google.common.collect.ImmutableSet;
import com.rwtema.denseores.DenseOresConfig;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.ModIntegration;
import com.rwtema.denseores.Proxy;
import com.rwtema.denseores.WorldGenOres;
import com.rwtema.denseores.client.ModelGen;
import com.rwtema.denseores.compat.Compat;
import com.rwtema.denseores.debug.WorldGenAnalyser;
import com.rwtema.denseores.utils.LogHelper;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="denseores", version="1.0", dependencies="after:*", acceptedMinecraftVersions="[1.9,1.11.2]")
public class DenseOresMod {
    public static final String MODID = "denseores";
    public static final String VERSION = "1.0";
    @SidedProxy(serverSide="com.rwtema.denseores.Proxy", clientSide="com.rwtema.denseores.ProxyClient")
    public static Proxy proxy;
    private File config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        final String version = Loader.instance().getMinecraftModContainer().getVersion();
        if (ImmutableSet.of((Object)"1.9", (Object)"1.9.1", (Object)"1.9.2", (Object)"1.9.3", (Object)"1.9.4", (Object)"1.10", (Object[])new String[]{"1.10.1", "1.10.2"}).contains((Object)version) && !ModAPIManager.INSTANCE.hasAPI("compatlayer")) {
            throw proxy.wrap((RuntimeException)new EnhancedRuntimeException(String.format("Dense Ores requires CompatLayer to run in Minecraft %s", version)){

                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    stream.println(String.format("Dense Ores Mod requires CompatLayer to run in Minecraft %s", version));
                }
            });
        }
        this.config = event.getSuggestedConfigurationFile();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LogHelper.info("Ph'nglui mglw'nafh, y'uln Dense Ores shugg ch'agl", new Object[0]);
        DenseOresConfig.instance.loadConfig(this.config);
        for (FMLInterModComms.IMCMessage message : FMLInterModComms.fetchRuntimeMessages((Object)this)) {
            String key = message.key;
            try {
                int metadata;
                ResourceLocation location;
                if (!key.startsWith("addDenseOre")) continue;
                Class messageType = message.getMessageType();
                int rendertype = 0;
                String underlyingBlockTexture = "blocks/stone";
                switch (key.substring("addDenseOre".length())) {
                    case "Stone": {
                        underlyingBlockTexture = "blocks/stone";
                        break;
                    }
                    case "Netherrack": {
                        underlyingBlockTexture = "blocks/netherrack";
                        break;
                    }
                    case "EndStone": {
                        underlyingBlockTexture = "blocks/end_stone";
                        break;
                    }
                    case "Obsidian": {
                        underlyingBlockTexture = "blocks/obsidian";
                    }
                }
                String texture = null;
                String unofficialName = null;
                if (messageType == ItemStack.class) {
                    ItemStack stack = message.getItemStackValue();
                    ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                    location = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)itemBlock.field_150939_a);
                    metadata = itemBlock.func_77647_b(itemBlock.getDamage(stack));
                } else if (messageType == NBTTagCompound.class) {
                    NBTTagCompound nbt = message.getNBTValue();
                    location = new ResourceLocation(nbt.func_74779_i("baseBlock"));
                    metadata = nbt.func_74762_e("baseBlockMeta");
                    if (nbt.func_150297_b("baseBlockTexture", 8)) {
                        texture = nbt.func_74779_i("baseBlockTexture");
                    }
                    if (nbt.func_150297_b("underlyingBlockTexture", 8)) {
                        underlyingBlockTexture = nbt.func_74779_i("underlyingBlockTexture");
                    }
                    rendertype = nbt.func_74762_e("renderType");
                    unofficialName = nbt.func_74779_i("config_entry");
                } else {
                    throw new IllegalArgumentException("Unable to process IMC type: " + messageType);
                }
                if (unofficialName == null || "".equals(unofficialName)) {
                    unofficialName = null;
                }
                DenseOresRegistry.registerOre(unofficialName, location, metadata, underlyingBlockTexture, texture, 0, rendertype);
            }
            catch (Exception err) {
                throw new ReportedException(new CrashReport("Unabled to load IMC message from " + message.getSender(), (Throwable)err));
            }
        }
        DenseOresRegistry.buildBlocks();
        ModelGen.register();
        DenseOresRegistry.buildOreDictionary();
        ModIntegration.addModIntegration();
        WorldGenOres worldGen = new WorldGenOres();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)1000);
        MinecraftForge.EVENT_BUS.register((Object)worldGen);
        if (LogHelper.isDeObf && Compat.INSTANCE.isV11()) {
            ((Runnable)WorldGenAnalyser::registerWorldGen).run();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        LogHelper.info("Dense Ores is fully loaded but sadly it cannot tell you the unlocalized name for dirt.", new Object[0]);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (LogHelper.isDeObf) {
            ((Consumer<FMLServerStartingEvent>)WorldGenAnalyser::register).accept(event);
        }
    }
}

