/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.blocks.BlockDenseOre;
import com.rwtema.denseores.blocks.ItemBlockDenseOre;
import com.rwtema.denseores.compat.Compat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class DenseOresRegistry {
    public static Map<ResourceLocation, DenseOre> ores = new HashMap<ResourceLocation, DenseOre>();
    public static String blockPrefix = "denseores";

    public static void initVanillaOres() {
        DenseOresRegistry.registerOre("Vanilla Iron Ore", new ResourceLocation("iron_ore"), 0, "blocks/stone", "blocks/iron_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Gold Ore", new ResourceLocation("gold_ore"), 0, "blocks/stone", "blocks/gold_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Lapis Ore", new ResourceLocation("lapis_ore"), 0, "blocks/stone", "blocks/lapis_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Diamond Ore", new ResourceLocation("diamond_ore"), 0, "blocks/stone", "blocks/diamond_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Emerald Ore", new ResourceLocation("emerald_ore"), 0, "blocks/stone", "blocks/emerald_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Redstone Ore", new ResourceLocation("redstone_ore"), 0, "blocks/stone", "blocks/redstone_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Coal Ore", new ResourceLocation("coal_ore"), 0, "blocks/stone", "blocks/coal_ore", 0, 0);
        DenseOresRegistry.registerOre("Vanilla Quartz Ore", new ResourceLocation("quartz_ore"), 0, "blocks/netherrack", "blocks/quartz_ore", 0, 0);
    }

    public static void buildBlocks() {
        for (DenseOre ore : ores.values()) {
            BlockDenseOre block = new BlockDenseOre(ore);
            ItemBlockDenseOre itemBlockDenseOre = new ItemBlockDenseOre(block);
            block.setRegistryName(ore.name);
            block.func_149663_c(ore.name.toString());
            itemBlockDenseOre.setRegistryName(ore.name);
            itemBlockDenseOre.func_77655_b(ore.name.toString());
            GameRegistry.register((IForgeRegistryEntry)block);
            GameRegistry.register((IForgeRegistryEntry)itemBlockDenseOre);
            ore.setBlock(block);
        }
    }

    public static DenseOre registerOre(@Nullable String unofficialName, ResourceLocation baseBlock, int metadata, String underlyingBlock, @Nullable String texture, int retroGenId, int renderType) {
        if ("".equals(baseBlock.toString()) || "minecraft:air".equals(baseBlock.toString())) {
            return null;
        }
        String resourceDomain = baseBlock.func_110624_b();
        if (!"minecraft".equals(resourceDomain) && !Loader.isModLoaded((String)Compat.INSTANCE.makeLowercase(resourceDomain))) {
            return null;
        }
        ResourceLocation name = new ResourceLocation("denseores", (resourceDomain + "_" + baseBlock.func_110623_a() + "_" + metadata).toLowerCase(Locale.ENGLISH));
        if ("".equals(texture)) {
            texture = null;
        }
        if (unofficialName == null) {
            unofficialName = name.toString();
        }
        DenseOre ore = new DenseOre(unofficialName, name, baseBlock, metadata, underlyingBlock, texture, retroGenId, renderType);
        ores.put(name, ore);
        return ore;
    }

    public static void buildOreDictionary() {
        for (DenseOre ore : ores.values()) {
            if (!ore.block.isValid()) continue;
            for (int oreid : OreDictionary.getOreIDs((ItemStack)new ItemStack(ore.block.getBlock(), 1, ore.metadata))) {
                String newOreName;
                String oreName = OreDictionary.getOreName((int)oreid);
                if (oreName.length() <= 3 || !oreName.startsWith("ore") || !Character.isUpperCase(oreName.charAt(3))) continue;
                ore.baseOreDictionaryEntry = oreName;
                ore.oreDictionary = newOreName = "dense" + oreName;
                OreDictionary.registerOre((String)newOreName, (ItemStack)new ItemStack((Block)ore.block));
            }
        }
    }
}

