/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.compat.Compat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public class ModIntegration {
    public static final String[] canonOres = new String[]{"oreIron", "oreGold", "oreCopper", "oreTin", "oreSilver", "oreLead", "oreNickel", "orePlatinum"};
    public static final String[] canonSecondaryOres = new String[]{"oreNickel", null, "oreGold", "oreIron", "oreLead", "oreSilver", "orePlatinum", null};
    public static ModInterface[] mods = new ModInterface[]{new VanillaFurnace(), new ExtraUtilsCompat(), new EnderIOCompat()};

    public static boolean isCanonOre(String ore) {
        return Arrays.stream(canonOres).anyMatch(s -> s.equals(ore));
    }

    public static String getSecondCanonOre(String ore) {
        for (int i = 0; i < canonOres.length; ++i) {
            if (!canonOres[i].equals(ore)) continue;
            return canonSecondaryOres[i];
        }
        return null;
    }

    public static NBTTagCompound getItemStackNBT(ItemStack item, int newStackSize) {
        NBTTagCompound tag = ModIntegration.getItemStackNBT(item);
        tag.func_74774_a("Count", (byte)newStackSize);
        return tag;
    }

    public static NBTTagCompound getItemStackNBT(ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        item.func_77955_b(tag);
        return tag;
    }

    public static ItemStack cloneStack(ItemStack item, int newStackSize) {
        ItemStack newitem = item.func_77946_l();
        Compat.INSTANCE.setStackSize(newitem, newStackSize);
        return newitem;
    }

    public static boolean isOreSmeltsToIngot(String oreDict) {
        if ("".equals(oreDict)) {
            return false;
        }
        String ingotName = "ingot" + oreDict.substring("ore".length());
        return !OreDictionary.getOres((String)ingotName).isEmpty();
    }

    public static ItemStack getSmeltedIngot(String oreDict, String preferredModOwner) {
        if ("".equals(oreDict)) {
            return null;
        }
        String ingotName = "ingot" + oreDict.substring("ore".length());
        ItemStack out = null;
        Iterator iterator = OreDictionary.getOres((String)ingotName).iterator();
        while (iterator.hasNext()) {
            ItemStack ingot;
            out = ingot = (ItemStack)iterator.next();
            ResourceLocation s = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)ingot.func_77973_b());
            if (preferredModOwner == null || !preferredModOwner.equals(preferredModOwner.equals(s.func_110624_b()))) continue;
            return out;
        }
        return out;
    }

    public static ItemStack getFurnace(DenseOre toSmelt, float multiplier) {
        ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt.newStack(1));
        if (Compat.INSTANCE.isValid(out)) {
            out = out.func_77946_l();
            if (new ResourceLocation("minecraft:lapis_ore").equals((Object)toSmelt.baseBlock)) {
                Compat.INSTANCE.setStackSize(out, 6);
            } else if (new ResourceLocation("minecraft:redstone_ore").equals((Object)toSmelt.baseBlock)) {
                Compat.INSTANCE.setStackSize(out, 4);
            }
            ModIntegration.multiplyStackSize(out, multiplier);
        }
        return out;
    }

    public static ItemStack multiplyStackSize(@Nonnull ItemStack out, float multiplier) {
        out = out.func_77946_l();
        Compat.INSTANCE.setStackSize(out, Math.round((float)Compat.INSTANCE.getStackSize(out) * multiplier));
        if (Compat.INSTANCE.getStackSize(out) > out.func_77976_d()) {
            Compat.INSTANCE.setStackSize(out, out.func_77976_d());
        }
        if (Compat.INSTANCE.getStackSize(out) < 1) {
            Compat.INSTANCE.setStackSize(out, 1);
        }
        return out;
    }

    public static void addModIntegration() {
        for (DenseOre ore : DenseOresRegistry.ores.values()) {
            ItemStack output = new ItemStack(ore.getBaseBlock(), 1, ore.metadata);
            ItemStack input = new ItemStack((Block)ore.block, 1, 0);
            for (ModInterface mod : mods) {
                mod.registerOre(ore, input, output);
            }
        }
    }

    @Nonnull
    private static String getModID(String modID) {
        return Compat.INSTANCE.isV11() ? modID.toLowerCase(Locale.US) : modID;
    }

    public static class ExtraUtilsCompat
    implements ModInterface {
        @Override
        public void registerOre(DenseOre ore, ItemStack input, ItemStack output) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("machine", "extrautils2:crusher");
            compound.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
            compound.func_74782_a("output", (NBTBase)ModIntegration.multiplyStackSize(output, 4.0f).func_77955_b(new NBTTagCompound()));
            FMLInterModComms.sendMessage((String)ModIntegration.getModID("ExtraUtils2"), (String)"addMachineRecipe", (NBTTagCompound)compound);
        }
    }

    public static class EnderIOCompat
    implements ModInterface {
        @Override
        public void registerOre(DenseOre ore, ItemStack input, ItemStack output) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<recipeGroup name=\"").append("DenseOres").append("\" >");
            stringBuilder.append("<recipe name=\"").append("denseores_").append(ore.name.func_110623_a()).append("\" energyCost=\"3600\" >");
            stringBuilder.append("<input>");
            this.addEnderIOXMLEntryItemStack(input, stringBuilder);
            stringBuilder.append("</input>");
            stringBuilder.append("<output>");
            this.addEnderIOXMLEntryItemStack(ModIntegration.multiplyStackSize(output, 4.0f), stringBuilder);
            stringBuilder.append("</output>");
            stringBuilder.append("</recipe>");
            stringBuilder.append("</recipeGroup>");
            String s = stringBuilder.toString();
            FMLInterModComms.sendMessage((String)ModIntegration.getModID("EnderIO"), (String)"recipe:sagmill", (String)s);
        }

        private void addEnderIOXMLEntryItemStack(ItemStack input, StringBuilder stringBuilder) {
            ResourceLocation nameForObject = (ResourceLocation)Validate.notNull((Object)Item.field_150901_e.func_177774_c((Object)input.func_77973_b()));
            stringBuilder.append("<itemStack modID=\"");
            stringBuilder.append(nameForObject.func_110624_b());
            stringBuilder.append("\" itemName=\"");
            stringBuilder.append(nameForObject.func_110623_a());
            stringBuilder.append("\" itemMeta=\"");
            stringBuilder.append(input.func_77960_j());
            stringBuilder.append("\" number = \"");
            stringBuilder.append(Compat.INSTANCE.getStackSize(input));
            stringBuilder.append("\" />");
        }
    }

    public static class VanillaFurnace
    implements ModInterface {
        @Override
        public void registerOre(DenseOre ore, ItemStack input, ItemStack output) {
            ItemStack out = ModIntegration.getFurnace(ore, 3.0f);
            if (!Compat.INSTANCE.isEmpty(out)) {
                GameRegistry.addSmelting((ItemStack)input, (ItemStack)ModIntegration.multiplyStackSize(out, 3.0f), (float)1.0f);
            }
        }
    }

    public static interface ModInterface {
        public void registerOre(DenseOre var1, ItemStack var2, ItemStack var3);
    }
}

