/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.client;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.blocks.BlockDenseOre;
import com.rwtema.denseores.client.EmptyBakedModel;
import com.rwtema.denseores.client.TextureOre;
import com.rwtema.denseores.utils.ModelBuilder;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelGen {
    public static void register() {
        MinecraftForge.EVENT_BUS.register(ModelGen.class);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public static void loadTextures(TextureStitchEvent.Pre event) {
        ModelManager manager = (ModelManager)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"modelManager", "field_175617_aL", "field_178090_d", "field_178128_c"});
        BlockModelShapes shapes = manager.func_174954_c();
        BlockStateMapper mapper = shapes.func_178120_a();
        block2: for (DenseOre ore : DenseOresRegistry.ores.values()) {
            if (ore.texture != null) continue;
            IBlockState state = ore.getBaseBlock().func_176203_a(ore.metadata);
            Map map = mapper.func_188181_b(ore.getBaseBlock());
            ModelResourceLocation modelResourceLocation = (ModelResourceLocation)map.get(state);
            IModel model = null;
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)modelResourceLocation);
            }
            catch (Exception e) {
                continue;
            }
            Collection textures = model.getTextures();
            for (ResourceLocation texture : textures) {
                if (texture.equals((Object)new ResourceLocation(ore.underlyingBlockTexture))) continue;
                ore.texture = texture.toString();
                continue block2;
            }
        }
        for (DenseOre ore : DenseOresRegistry.ores.values()) {
            if (ore.texture == null || "".equals(ore.texture)) {
                ore.sprite = event.getMap().func_174944_f();
                continue;
            }
            TextureOre textureOre = new TextureOre(ore);
            event.getMap().setTextureEntry((TextureAtlasSprite)textureOre);
            ore.sprite = event.getMap().getTextureExtry(textureOre.func_94215_i());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public static void addModels(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        ModelManager manager = event.getModelManager();
        BlockModelShapes shapes = manager.func_174954_c();
        BlockStateMapper mapper = shapes.func_178120_a();
        for (DenseOre denseOre : DenseOresRegistry.ores.values()) {
            BlockDenseOre block = denseOre.block;
            Item item = Item.func_150898_a((Block)block);
            modelRegistry.func_82595_a((Object)new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), "inventory"), (Object)new EmptyBakedModel());
            Map locations = new DefaultStateMapper().func_178130_a((Block)block);
            final ModelResourceLocation[] invModels = new ModelResourceLocation[1];
            for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
                ModelResourceLocation blockLocation = (ModelResourceLocation)locations.get(iBlockState);
                ModelResourceLocation inventoryLocation = new ModelResourceLocation(Item.field_150901_e.func_177774_c((Object)item) + "_dense", "inventory");
                ModelResourceLocation location = (ModelResourceLocation)mapper.func_188181_b(denseOre.getBaseBlock()).get(denseOre.getBaseState());
                IBakedModel parentModel = null;
                if (location != null) {
                    parentModel = (IBakedModel)modelRegistry.func_82594_a((Object)location);
                }
                if (parentModel == null) {
                    parentModel = (IBakedModel)modelRegistry.func_82594_a(mapper.func_188181_b(Blocks.field_150348_b).get(Blocks.field_150348_b.func_176223_P()));
                }
                IBakedModel iBakedModel = ModelBuilder.changeIcon(denseOre.getBaseState(), parentModel, denseOre.sprite);
                modelRegistry.func_82595_a((Object)blockLocation, (Object)iBakedModel);
                modelRegistry.func_82595_a((Object)inventoryLocation, (Object)iBakedModel);
                mesher.func_178086_a(item, 0, inventoryLocation);
                invModels[0] = inventoryLocation;
            }
            mesher.func_178080_a(item, new ItemMeshDefinition(){

                @Nonnull
                public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                    return invModels[0];
                }
            });
        }
    }
}

