/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.client;

import com.google.common.base.Throwables;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.blockstates.Offset;
import com.rwtema.denseores.utils.ColorHelper;
import com.rwtema.denseores.utils.LogHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureOre
extends TextureAtlasSprite {
    public String name;
    public String base;
    public int type;
    private int renderType = 0;

    public TextureOre(DenseOre denseOre) {
        this(denseOre.texture, denseOre.underlyingBlockTexture);
        this.renderType = denseOre.rendertype;
    }

    public TextureOre(String par1Str, String base) {
        super(TextureOre.getDerivedName(par1Str));
        this.name = par1Str;
        this.base = base;
    }

    public static String getDerivedName(String s2) {
        String s1 = "minecraft";
        int ind = s2.indexOf(58);
        if (ind >= 0) {
            if (ind > 1) {
                s1 = s2.substring(0, ind);
            }
            s2 = s2.substring(ind + 1, s2.length());
        }
        s1 = s1.toLowerCase();
        return "denseores:" + s1 + "/" + s2 + "_dense";
    }

    public static ResourceLocation getBlockResource(String s2) {
        String s1 = "minecraft";
        int ind = s2.indexOf(58);
        if (ind >= 0) {
            if (ind > 1) {
                s1 = s2.substring(0, ind);
            }
            s2 = s2.substring(ind + 1, s2.length());
        }
        s1 = s1.toLowerCase();
        s2 = "textures/" + s2 + ".png";
        return new ResourceLocation(s1, s2);
    }

    private static int[] createDenseTexture(int w, int[] ore_data, int[] stone_data, int renderType) {
        int[] new_data = new int[w * w];
        int r = w >> 4;
        boolean[] same = new boolean[w * w];
        for (int i = 0; i < ore_data.length; ++i) {
            if (ColorHelper.getAlpha(ore_data[i]) == 0) {
                same[i] = true;
                ore_data[i] = stone_data[i];
            } else if (ColorHelper.areColorsClose(ore_data[i], stone_data[i])) {
                same[i] = true;
            } else {
                int x = i % w;
                block3: for (int dx = -r; dx <= r; ++dx) {
                    if (x + dx <= 0 || x + dx > w) continue;
                    for (int dy = -(r * w); dy <= r * w; dy += w) {
                        int k = i + dx + dy;
                        if (k < 0 || k >= stone_data.length || !ColorHelper.areColorsClose(ore_data[i], stone_data[k])) continue;
                        same[i] = true;
                        break block3;
                    }
                }
            }
            new_data[i] = ore_data[i];
        }
        try {
            Offset offset = Offset.getOffset(renderType);
            int[] dx = offset.dx;
            int[] dy = offset.dy;
            block5: for (int i = 0; i < ore_data.length; ++i) {
                int x = i % w;
                int y = (i - x) / w;
                if (!same[i]) continue;
                for (int j = 0; j < dx.length; ++j) {
                    int new_x = x + dx[j];
                    int new_y = y + dy[j];
                    if (new_x < 0 || new_x >= w || new_y < 0 || new_y >= w || same[new_x + new_y * w]) continue;
                    new_data[i] = ore_data[new_x + new_y * w];
                    continue block5;
                }
            }
        }
        catch (Throwable err) {
            err.printStackTrace();
            throw Throwables.propagate((Throwable)err);
        }
        return new_data;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public void func_147963_d(int level) {
        super.func_147963_d(level);
    }

    public boolean load(IResourceManager manager, final ResourceLocation location) {
        int w;
        BufferedImage stone_image;
        AnimationMetadataSection animation;
        PngSizeInfo sizeInfo;
        int mp = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        BufferedImage[] ore_image = new BufferedImage[1 + mp];
        try {
            BufferedImage read;
            IResource iresource = manager.func_110536_a(TextureOre.getBlockResource(this.name));
            IResource iresourceBase = manager.func_110536_a(TextureOre.getBlockResource(this.base));
            sizeInfo = new PngSizeInfo(manager.func_110536_a(TextureOre.getBlockResource(this.name)).func_110527_b());
            ore_image[0] = read = ImageIO.read(iresource.func_110527_b());
            animation = (AnimationMetadataSection)iresource.func_110526_a("animation");
            stone_image = ImageIO.read(iresourceBase.func_110527_b());
            w = ore_image[0].getWidth();
            if (stone_image.getWidth() != w) {
                IResource resource;
                List resourcePacks = manager.func_135056_b(TextureOre.getBlockResource(this.base));
                for (int i = resourcePacks.size() - 1; i >= 0 && (stone_image = ImageIO.read((resource = (IResource)resourcePacks.get(i)).func_110527_b())).getWidth() != w; --i) {
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        if (stone_image.getWidth() != w) {
            LogHelper.error("Error generating texture" + this.name + ". Unable to find base texture with same size.");
            return true;
        }
        int h = ore_image[0].getHeight();
        BufferedImage output_image = new BufferedImage(w, h, 2);
        int[] ore_data = new int[w * w];
        int[] stone_data = new int[w * w];
        stone_image.getRGB(0, 0, w, w, stone_data, 0, w);
        for (int y = 0; y < h; y += w) {
            ore_image[0].getRGB(0, y, w, w, ore_data, 0, w);
            int[] new_data = TextureOre.createDenseTexture(w, ore_data, stone_data, this.renderType);
            output_image.setRGB(0, y, w, w, new_data, 0, w);
        }
        ore_image[0] = output_image;
        try {
            this.func_188538_a(sizeInfo, animation != null);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)output_image, "PNG", stream);
            final byte[] bytes = stream.toByteArray();
            this.func_188539_a(new IResource(){

                @Nonnull
                public ResourceLocation func_177241_a() {
                    return location;
                }

                @Nonnull
                public InputStream func_110527_b() {
                    return new ByteArrayInputStream(bytes);
                }

                public boolean func_110528_c() {
                    return true;
                }

                @Nullable
                public <T extends IMetadataSection> T func_110526_a(String sectionName) {
                    if ("animation".equals(sectionName)) {
                        return (T)animation;
                    }
                    return null;
                }

                @Nonnull
                public String func_177240_d() {
                    return "test";
                }

                public void close() throws IOException {
                }
            }, mp + 1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogHelper.trace("Dense Ores: Succesfully generated dense ore texture for '" + this.name + "' with background '" + this.base + "'. Place " + this.name + "_dense.png in the assets folder to override.");
        return false;
    }
}

