/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.utils;

import net.minecraft.util.math.MathHelper;

public class ColorHelper {
    public static int multiply(int col, float mult) {
        return ColorHelper.makeCol(ColorHelper.clamp((float)ColorHelper.getRed(col) * mult), ColorHelper.clamp((float)ColorHelper.getGreen(col) * mult), ColorHelper.clamp((float)ColorHelper.getBlue(col) * mult), ColorHelper.getAlpha(col));
    }

    public static int clamp(float c) {
        return (int)MathHelper.func_76131_a((float)c, (float)0.0f, (float)255.0f);
    }

    public static int getAlpha(int col) {
        return (col & 0xFF000000) >>> 24;
    }

    public static int getRed(int col) {
        return (col & 0xFF0000) >> 16;
    }

    public static int getGreen(int col) {
        return (col & 0xFF00) >> 8;
    }

    public static int getBlue(int col) {
        return col & 0xFF;
    }

    public static int makeCol(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static boolean areColorsClose(int a, int b) {
        return ColorHelper.areColorsClose(a, b, 20);
    }

    public static boolean areColorsClose(int a, int b, int threshold) {
        int db;
        int dg;
        if (a == b) {
            return true;
        }
        int dr = Math.abs(ColorHelper.getRed(a) - ColorHelper.getRed(b));
        return dr + (dg = Math.abs(ColorHelper.getGreen(a) - ColorHelper.getGreen(b))) + (db = Math.abs(ColorHelper.getBlue(a) - ColorHelper.getBlue(b))) < threshold;
    }
}

