/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.utils;

import com.google.common.collect.ImmutableList;
import com.rwtema.denseores.ModelBuilder.PerspectiveWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IPerspectiveAwareModel;

public class ModelBuilder {
    public static SimpleBakedModel newBlankModel(TextureAtlasSprite texture) {
        return new SimpleBakedModel(new LinkedList(), ModelBuilder.newBlankFacingLists(), true, true, texture, ItemCameraTransforms.field_178357_a, new ItemOverrideList((List)ImmutableList.of()));
    }

    public static BakedQuad copyQuad(BakedQuad quad) {
        return new BakedQuad(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static BakedQuad changeTexture(BakedQuad quad, TextureAtlasSprite tex) {
        quad = new BakedQuad(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), quad.func_178211_c(), quad.func_178210_d(), tex, quad.shouldApplyDiffuseLighting(), quad.getFormat());
        for (int i = 0; i < 4; ++i) {
            int j = 7 * i;
            float x = Float.intBitsToFloat(quad.func_178209_a()[j]);
            float y = Float.intBitsToFloat(quad.func_178209_a()[j + 1]);
            float z = Float.intBitsToFloat(quad.func_178209_a()[j + 2]);
            float u = 0.0f;
            float v = 0.0f;
            if (x < 0.0f || x > 1.0f) {
                x = (x + 1.0f) % 1.0f;
            }
            if (y < 0.0f || y > 1.0f) {
                y = (y + 1.0f) % 1.0f;
            }
            if (z < 0.0f || z > 1.0f) {
                z = (z + 1.0f) % 1.0f;
            }
            switch (quad.func_178210_d().ordinal()) {
                case 0: {
                    u = x * 16.0f;
                    v = (1.0f - z) * 16.0f;
                    break;
                }
                case 1: {
                    u = x * 16.0f;
                    v = z * 16.0f;
                    break;
                }
                case 2: {
                    u = (1.0f - x) * 16.0f;
                    v = (1.0f - y) * 16.0f;
                    break;
                }
                case 3: {
                    u = x * 16.0f;
                    v = (1.0f - y) * 16.0f;
                    break;
                }
                case 4: {
                    u = z * 16.0f;
                    v = (1.0f - y) * 16.0f;
                    break;
                }
                case 5: {
                    u = (1.0f - z) * 16.0f;
                    v = (1.0f - y) * 16.0f;
                }
            }
            quad.func_178209_a()[j + 4] = Float.floatToRawIntBits(tex.func_94214_a((double)u));
            quad.func_178209_a()[j + 4 + 1] = Float.floatToRawIntBits(tex.func_94207_b((double)v));
        }
        return quad;
    }

    public static IBakedModel changeIcon(IBlockState state, IBakedModel model, TextureAtlasSprite texture) {
        LinkedList<BakedQuad> generalQuadsList = new LinkedList<BakedQuad>();
        Map<EnumFacing, List<BakedQuad>> blankFacingLists = ModelBuilder.newBlankFacingLists();
        SimpleBakedModel bakedModel = new SimpleBakedModel(generalQuadsList, blankFacingLists, model.func_177556_c(), model.func_177555_b(), texture, model.func_177552_f(), new ItemOverrideList((List)ImmutableList.of()));
        for (BakedQuad quad : model.func_188616_a(state, null, 0L)) {
            generalQuadsList.add(ModelBuilder.changeTexture(quad, texture));
        }
        for (EnumFacing facing : EnumFacing.values()) {
            for (BakedQuad o : model.func_188616_a(state, facing, 0L)) {
                blankFacingLists.get(facing).add(ModelBuilder.changeTexture(o, texture));
            }
        }
        Object result = bakedModel;
        if (model instanceof IPerspectiveAwareModel) {
            result = new PerspectiveWrapper((IBakedModel)result, (IPerspectiveAwareModel)model);
        }
        return result;
    }

    public static Map<EnumFacing, List<BakedQuad>> newBlankFacingLists() {
        EnumMap<EnumFacing, List<BakedQuad>> quadsMap = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            quadsMap.put(facing, new ArrayList());
        }
        return quadsMap;
    }

    public static ModelResourceLocation getModelResourceLocation(IBlockState state) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), new DefaultStateMapper().func_178131_a((Map)state.func_177228_b()));
    }
}

