/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.registry;

import electroblob.tfspellpack.entity.construct.EntityAcidRainCloud;
import electroblob.tfspellpack.entity.construct.EntityCinderCloud;
import electroblob.tfspellpack.entity.construct.EntityDarkMistCloud;
import electroblob.tfspellpack.entity.construct.EntityFireJet;
import electroblob.tfspellpack.entity.construct.EntityTearRain;
import electroblob.tfspellpack.entity.living.EntityCaveTrollMinion;
import electroblob.tfspellpack.entity.living.EntityDruidMage;
import electroblob.tfspellpack.entity.living.EntityFireBeetleMinion;
import electroblob.tfspellpack.entity.living.EntityMiniGhastMinion;
import electroblob.tfspellpack.entity.living.EntityRedcapMinion;
import electroblob.tfspellpack.entity.living.EntityRedcapSapperMinion;
import electroblob.tfspellpack.entity.living.EntitySkeletonDruidMinion;
import electroblob.tfspellpack.entity.living.EntitySlimeBeetleMinion;
import electroblob.tfspellpack.entity.living.EntitySnowGuardianMinion;
import electroblob.tfspellpack.entity.living.EntityStableIceCoreMinion;
import electroblob.tfspellpack.entity.living.EntityTwilightWraithMinion;
import electroblob.tfspellpack.entity.living.EntityUnstableIceCoreMinion;
import electroblob.tfspellpack.entity.projectile.EntityMagicHydraMortar;
import electroblob.tfspellpack.entity.projectile.EntityTear;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public final class TFSPEntities {
    private static int id = 0;

    private TFSPEntities() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntitySkeletonDruidMinion.class, "skeleton_druid_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityStableIceCoreMinion.class, "stable_ice_core_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityUnstableIceCoreMinion.class, "unstable_ice_core_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityFireBeetleMinion.class, "fire_beetle_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntitySlimeBeetleMinion.class, "slime_beetle_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityRedcapMinion.class, "redcap_goblin_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityRedcapSapperMinion.class, "redcap_sapper_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityTwilightWraithMinion.class, "twilight_wraith_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntitySnowGuardianMinion.class, "snow_guardian_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityMiniGhastMinion.class, "carminite_ghastling_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityCaveTrollMinion.class, "cave_troll_minion", TrackingType.LIVING).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityDruidMage.class, "druid_mage", TrackingType.LIVING).egg(922632, 13762304).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityMagicHydraMortar.class, "magic_hydra_mortar", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityTear.class, "fiery_tear", TrackingType.PROJECTILE).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityTearRain.class, "rain_of_tears", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityAcidRainCloud.class, "acid_rain_cloud", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityCinderCloud.class, "cinder_cloud", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityFireJet.class, "fire_jet", TrackingType.CONSTRUCT).build());
        registry.register((IForgeRegistryEntry)TFSPEntities.createEntry(EntityDarkMistCloud.class, "dark_mist_cloud", TrackingType.CONSTRUCT).build());
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name, TrackingType tracking) {
        return TFSPEntities.createEntry(entityClass, name).tracker(tracking.range, tracking.interval, tracking.trackVelocity);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntry(Class<T> entityClass, String name) {
        ResourceLocation registryName = new ResourceLocation("tfspellpack", name);
        return EntityEntryBuilder.create().entity(entityClass).id(registryName, id++).name(registryName.toString());
    }

    static enum TrackingType {
        LIVING(80, 3, true),
        PROJECTILE(64, 10, true),
        CONSTRUCT(160, 10, false);

        int range;
        int interval;
        boolean trackVelocity;

        private TrackingType(int range, int interval, boolean trackVelocity) {
            this.range = range;
            this.interval = interval;
            this.trackVelocity = trackVelocity;
        }
    }
}

