/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import twilightforest.item.ItemTFCrumbleHorn;
import twilightforest.item.TFItems;

public class CallOfTheHorn
extends SpellRay {
    private static final Method crumbleBlocksInAABB;

    public CallOfTheHorn() {
        super("tfspellpack", "call_of_the_horn", SpellActions.POINT_UP, true);
        this.ignoreLivingEntities(true);
        this.hitLiquids(false);
        this.soundValues(1.0f, 0.8f, 0.0f);
        this.addProperties(new String[]{"effect_radius"});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        if (!world.field_72995_K && ticksInUse > 10 && ticksInUse % 5 == 0) {
            double radius = this.getProperty("effect_radius").doubleValue() * (double)modifiers.get(WizardryItems.blast_upgrade);
            AxisAlignedBB crumbleBox = new AxisAlignedBB(hit.field_72450_a - radius, hit.field_72448_b - radius, hit.field_72449_c - radius, hit.field_72450_a + radius, hit.field_72448_b + radius, hit.field_72449_c + radius);
            try {
                crumbleBlocksInAABB.invoke((Object)TFItems.crumble_horn, ItemStack.field_190927_a, world, caster, crumbleBox);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        if (ticksInUse > 10 && ticksInUse % 5 == 0) {
            super.playSound(world, x, y, z, ticksInUse, duration, modifiers, sounds);
        }
    }

    static {
        Method m = null;
        try {
            m = ItemTFCrumbleHorn.class.getDeclaredMethod("crumbleBlocksInAABB", ItemStack.class, World.class, EntityLivingBase.class, AxisAlignedBB.class);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        crumbleBlocksInAABB = m;
    }
}

