/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;

public class LifeCharm
extends SpellBuff {
    public static final String HEALTH_LEVEL = "health_level";

    public LifeCharm() {
        super("tfspellpack", "life_charm", 0.82f, 0.36f, 0.46f, new Supplier[]{() -> MobEffects.field_76428_l});
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
        this.addProperties(new String[]{HEALTH_LEVEL});
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        float healAmount;
        float healthLevel = this.getProperty(HEALTH_LEVEL).floatValue();
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)TFSPItems.amulet_life_charm)) {
            healthLevel = caster.func_110138_aP();
            caster.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 600, 0));
        }
        if ((healAmount = healthLevel - caster.func_110143_aJ()) > 0.0f) {
            caster.func_70691_i(healAmount);
        }
        return super.applyEffects(caster, modifiers) || healAmount > 0.0f;
    }
}

