/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.entity.living.EntityStableIceCoreMinion;
import electroblob.tfspellpack.entity.living.EntityUnstableIceCoreMinion;
import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonIceCore
extends SpellMinion<EntityStableIceCoreMinion> {
    private static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";

    public SummonIceCore() {
        super("tfspellpack", "summon_ice_core", EntityStableIceCoreMinion::new);
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)TFSPItems.charm_ice_exploder)) {
            return this.spawnUnstableIceCore(world, caster, modifiers);
        }
        return super.spawnMinions(world, caster, modifiers);
    }

    private boolean spawnUnstableIceCore(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty("minion_count").intValue(); ++i) {
                int range = this.getProperty("summon_radius").intValue();
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2));
                if (pos == null) {
                    return false;
                }
                EntityUnstableIceCoreMinion minion = new EntityUnstableIceCoreMinion(world);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                minion.setCaster(caster);
                minion.setLifetime((int)(this.getProperty("minion_lifetime").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                IAttributeInstance attribute = minion.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (attribute != null) {
                    attribute.func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
                }
                minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("minion_health", (double)(modifiers.get("minion_health") - 1.0f), 2));
                minion.func_70606_j(minion.func_110138_aP());
                minion.func_180482_a(minion.field_70170_p.func_175649_E(pos), null);
                world.func_72838_d((Entity)minion);
            }
        }
        return true;
    }
}

