/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.config.SpawnConfig;
import com.branders.spawnermod.item.SpawnerKeyItem;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnerEventHandler {
    private float SPAWN_RATE = (float)((Integer)SpawnConfig.monster_egg_drop_chance.get()).intValue() / 100.0f;
    private Random random = new Random();
    private EntityType<?> defaultEntityType = EntityType.field_200788_b;

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        ListNBT list;
        if (event.getState().func_177230_c() == Blocks.field_150474_ac && this.checkSilkTouch(list = event.getPlayer().func_184614_ca().func_77986_q())) {
            event.setExpToDrop(0);
            ItemStack itemStack = new ItemStack((IItemProvider)Blocks.field_150474_ac.func_199767_j());
            ItemEntity entityItem = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack);
            event.getWorld().func_217376_c((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        World world = (World)event.getWorld();
        BlockPos blockpos = event.getPos();
        BlockState iblockstate = world.func_180495_p(blockpos);
        MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)world.func_175625_s(blockpos);
        AbstractSpawner logic = spawner.func_145881_a();
        logic.func_200876_a(this.defaultEntityType);
        spawner.func_70296_d();
        world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (this.random.nextFloat() > this.SPAWN_RATE) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType entityType = entity.func_200600_R();
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entityType.getRegistryName() + "_spawn_egg")));
        event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (event.getItemStack().func_77973_b() instanceof BlockItem || event.getHand() == Hand.OFF_HAND) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof SpawnerKeyItem) {
            return;
        }
        BlockPos blockpos = event.getPos();
        BlockState iblockstate = world.func_180495_p(blockpos);
        if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        this.dropMonsterEgg(world, blockpos, iblockstate);
    }

    private void dropMonsterEgg(World world, BlockPos blockpos, BlockState iblockstate) {
        MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)world.func_175625_s(blockpos);
        AbstractSpawner logic = spawner.func_145881_a();
        CompoundNBT nbt = new CompoundNBT();
        nbt = logic.func_189530_b(nbt);
        String entity_string = nbt.func_74781_a("SpawnData").toString();
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).equalsIgnoreCase(this.defaultEntityType.getRegistryName().toString())) {
            return;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entity_string + "_spawn_egg")));
        double d0 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.06f + 0.6;
        double d2 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        ItemEntity entityItem = new ItemEntity(world, (double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d1, (double)blockpos.func_177952_p() + d2, itemStack);
        entityItem.func_174869_p();
        world.func_217376_c((Entity)entityItem);
        logic.func_200876_a(this.defaultEntityType);
        spawner.func_70296_d();
        world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
    }

    private boolean checkSilkTouch(ListNBT list) {
        return list.func_150285_a_().indexOf("minecraft:silk_touch") != -1;
    }
}

