/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.config.SpawnerModConfig;
import com.branders.spawnermod.gui.SpawnerConfigGui;
import com.branders.spawnermod.item.SpawnerKeyItem;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class SpawnerEventHandler {
    private ResourceLocation defaultEntityType = new ResourceLocation("area_effect_cloud");
    private float SPAWN_RATE = (float)(SpawnerModConfig.drop_rate_in_percentage / 100.0);
    private Random random = new Random();

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        NBTTagList list;
        if (event.getState().func_177230_c() == Blocks.field_150474_ac && this.checkSilkTouch(list = event.getPlayer().func_184614_ca().func_77986_q())) {
            event.setExpToDrop(0);
            ItemStack itemstack = new ItemStack(Blocks.field_150474_ac);
            World eventWorld = event.getWorld();
            BlockPos pos = event.getPos();
            EntityItem entityItem = new EntityItem(eventWorld, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
            eventWorld.func_72838_d((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        World world = event.getWorld();
        BlockPos blockpos = event.getPos();
        IBlockState iblockstate = world.func_180495_p(blockpos);
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(blockpos);
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        System.out.println();
        logic.func_190894_a(this.defaultEntityType);
        spawner.func_70296_d();
        world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (this.random.nextFloat() > this.SPAWN_RATE) {
            return;
        }
        Entity entity = event.getEntity();
        NBTTagCompound compound = entity.serializeNBT();
        ItemStack itemStack = this.getMonsterEgg(compound.func_74779_i("id"));
        event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (event.getItemStack().func_77973_b() instanceof ItemBlock || event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        BlockPos blockpos = event.getPos();
        IBlockState iblockstate = world.func_180495_p(blockpos);
        if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof SpawnerKeyItem) {
            if (!world.field_72995_K) {
                return;
            }
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(blockpos);
            MobSpawnerBaseLogic logic = spawner.func_145881_a();
            this.openSpawnerGui(logic, spawner);
        } else {
            if (world.field_72995_K) {
                return;
            }
            this.dropMonsterEgg(world, blockpos, iblockstate);
        }
    }

    private void dropMonsterEgg(World world, BlockPos blockpos, IBlockState iblockstate) {
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(blockpos);
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        NBTTagCompound nbtIn = new NBTTagCompound();
        nbtIn = logic.func_189530_b(nbtIn);
        String entity_string = nbtIn.func_74781_a("SpawnData").toString();
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).equalsIgnoreCase(this.defaultEntityType.toString())) {
            return;
        }
        ItemStack itemStack = this.getMonsterEgg(entity_string);
        double d0 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.06f + 0.6;
        double d2 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        EntityItem entityItem = new EntityItem(world, (double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d1, (double)blockpos.func_177952_p() + d2, itemStack);
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
        logic.func_190894_a(this.defaultEntityType);
        spawner.func_70296_d();
        world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
    }

    @SideOnly(value=Side.CLIENT)
    private void openSpawnerGui(MobSpawnerBaseLogic logic, TileEntityMobSpawner pos) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_152344_a(() -> mc.func_147108_a((GuiScreen)new SpawnerConfigGui(logic, pos)));
    }

    private ItemStack getMonsterEgg(String resourceLocation) {
        ItemStack itemStack = new ItemStack(Items.field_151063_bx);
        NBTTagCompound nbttagcompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", resourceLocation);
        nbttagcompound.func_74782_a("EntityTag", (NBTBase)nbttagcompound1);
        itemStack.func_77982_d(nbttagcompound);
        return itemStack;
    }

    private boolean checkSilkTouch(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String id = list.func_179238_g(i).toString();
            if (!(id = id.substring(11, 13)).equalsIgnoreCase("33")) continue;
            return true;
        }
        return false;
    }
}

