/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncSpawner
implements IMessage {
    private BlockPos pos;
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public MessageSyncSpawner() {
    }

    public MessageSyncSpawner(TileEntityMobSpawner tile, short delay, short spawnCount, short requiredPlayerRange, short maxNearbyEntities, short minSpawnDelay, short maxSpawnDelay) {
        this.pos = tile.func_174877_v();
        this.delay = delay;
        this.minSpawnDelay = minSpawnDelay;
        this.maxSpawnDelay = maxSpawnDelay;
        this.spawnCount = spawnCount;
        this.maxNearbyEntities = maxNearbyEntities;
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.delay = buf.readShort();
        this.maxNearbyEntities = buf.readShort();
        this.maxSpawnDelay = buf.readShort();
        this.minSpawnDelay = buf.readShort();
        this.requiredPlayerRange = buf.readShort();
        this.spawnCount = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeShort((int)this.delay);
        buf.writeShort((int)this.maxNearbyEntities);
        buf.writeShort((int)this.maxSpawnDelay);
        buf.writeShort((int)this.minSpawnDelay);
        buf.writeShort((int)this.requiredPlayerRange);
        buf.writeShort((int)this.spawnCount);
    }

    public static class Handler
    implements IMessageHandler<MessageSyncSpawner, IMessage> {
        public IMessage onMessage(MessageSyncSpawner msg, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            if (world != null) {
                if (!world.func_175667_e(msg.pos)) {
                    return null;
                }
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(msg.pos);
                MobSpawnerBaseLogic logic = spawner.func_145881_a();
                IBlockState iblockstate = world.func_180495_p(msg.pos);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt = logic.func_189530_b(nbt);
                nbt.func_74777_a("Delay", msg.delay);
                nbt.func_74777_a("SpawnCount", msg.spawnCount);
                nbt.func_74777_a("RequiredPlayerRange", msg.requiredPlayerRange);
                nbt.func_74777_a("MaxNearbyEntities", msg.maxNearbyEntities);
                nbt.func_74777_a("MinSpawnDelay", msg.minSpawnDelay);
                nbt.func_74777_a("MaxSpawnDelay", msg.maxSpawnDelay);
                logic.func_98270_a(nbt);
                spawner.func_70296_d();
                world.func_184138_a(msg.pos, iblockstate, iblockstate, 3);
            }
            return null;
        }
    }
}

