/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.config.SpawnConfig;
import com.branders.spawnermod.item.SpawnerKeyItem;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerEggDrop;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnerEventHandler {
    private float DROP_RATE = (float)((Double)SpawnConfig.monster_egg_drop_chance.get() / 100.0);
    private Random random = new Random();
    private EntityType<?> defaultEntityType = EntityType.field_200788_b;

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        ListNBT list;
        if (event.getState().func_177230_c() == Blocks.field_150474_ac && this.checkSilkTouch(list = event.getPlayer().func_184614_ca().func_77986_q())) {
            event.setExpToDrop(0);
            ItemStack itemStack = new ItemStack((IItemProvider)Blocks.field_150474_ac.func_199767_j());
            ItemEntity entityItem = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack);
            event.getWorld().func_217376_c((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = (World)event.getWorld();
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.defaultEntityType);
        tileentity.func_70296_d();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (this.random.nextFloat() > this.DROP_RATE) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType entityType = entity.func_200600_R();
        if (entityType.equals(EntityType.field_200729_aH)) {
            return;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entityType.getRegistryName() + "_spawn_egg")));
        event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, itemStack));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockpos;
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof BlockItem || item instanceof SpawnEggItem || item instanceof SpawnerKeyItem || event.getHand() == Hand.OFF_HAND) {
            return;
        }
        World world = event.getWorld();
        if (world.func_180495_p(blockpos = event.getPos()).func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        SpawnerModPacketHandler.INSTANCE.sendToServer((Object)new SyncSpawnerEggDrop(blockpos));
    }

    private boolean checkSilkTouch(ListNBT list) {
        return list.func_150285_a_().indexOf("minecraft:silk_touch") != -1;
    }
}

