/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.SpawnerMod;
import com.branders.spawnermod.config.SpawnerModConfig;
import com.branders.spawnermod.item.SpawnerKeyItem;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerEggDrop;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnerEventHandler {
    private Random random = new Random();
    private EntityType<?> defaultEntityType = EntityType.field_200788_b;

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        ListNBT list;
        if (event.getState().func_177230_c() == Blocks.field_150474_ac && this.checkSilkTouch(list = event.getPlayer().func_184614_ca().func_77986_q()) && !((Boolean)SpawnerModConfig.GENERAL.disable_silk_touch.get()).booleanValue()) {
            event.setExpToDrop(0);
            if (!((Boolean)SpawnerModConfig.GENERAL.disable_egg_removal_from_spawner.get()).booleanValue()) {
                this.dropMonsterEgg(event.getPos(), (World)event.getWorld());
            }
            ItemStack itemStack = new ItemStack((IItemProvider)Blocks.field_150474_ac.func_199767_j());
            ItemEntity entityItem = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack);
            event.getWorld().func_217376_c((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = (World)event.getWorld();
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.defaultEntityType);
        tileentity.func_70296_d();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if ((double)this.random.nextFloat() > (Double)SpawnerModConfig.GENERAL.monster_egg_drop_chance.get() / 100.0) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType entityType = entity.func_200600_R();
        if (entityType.equals(EntityType.field_200729_aH)) {
            return;
        }
        ItemStack itemStack = entityType.equals(EntityType.field_200757_aw) ? new ItemStack((IItemProvider)SpawnerMod.iron_golem_spawn_egg) : new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entityType.getRegistryName() + "_spawn_egg")));
        event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockpos;
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof BlockItem || item instanceof SpawnEggItem || item instanceof SpawnerKeyItem || event.getHand() == Hand.OFF_HAND) {
            return;
        }
        World world = event.getWorld();
        if (world.func_180495_p(blockpos = event.getPos()).func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        SpawnerModPacketHandler.INSTANCE.sendToServer((Object)new SyncSpawnerEggDrop(blockpos));
    }

    private void dropMonsterEgg(BlockPos pos, World world) {
        BlockState blockstate = world.func_180495_p(pos);
        MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)world.func_175625_s(pos);
        AbstractSpawner logic = spawner.func_145881_a();
        CompoundNBT nbt = new CompoundNBT();
        nbt = logic.func_189530_b(nbt);
        String entity_string = nbt.func_74781_a("SpawnData").toString();
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).equalsIgnoreCase(EntityType.field_200788_b.getRegistryName().toString())) {
            return;
        }
        ItemStack itemStack = entity_string.contains("iron_golem") ? new ItemStack((IItemProvider)SpawnerMod.iron_golem_spawn_egg) : new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entity_string + "_spawn_egg")));
        double d0 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.06f + 0.6;
        double d2 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemStack);
        entityItem.func_174869_p();
        world.func_217376_c((Entity)entityItem);
        logic.func_200876_a(EntityType.field_200788_b);
        spawner.func_70296_d();
        world.func_184138_a(pos, blockstate, blockstate, 3);
    }

    private boolean checkSilkTouch(ListNBT list) {
        return list.func_150285_a_().indexOf("minecraft:silk_touch") != -1;
    }
}

