/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.gui;

import com.branders.spawnermod.config.SpawnerModConfig;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerMessage;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpawnerConfigGui
extends Screen {
    private AbstractSpawner logic;
    private BlockPos pos;
    private CompoundNBT nbt = new CompoundNBT();
    private ResourceLocation spawnerConfigTexture = new ResourceLocation("spawnermod", "/textures/gui/spawner_config_screen.png");
    private int imageWidth = 178;
    private int imageHeight = 177;
    private Button countButton = null;
    private Button speedButton = null;
    private Button rangeButton = null;
    private int countOptionValue;
    private int speedOptionValue;
    private int rangeOptionValue;
    String[] speedDisplayString = new String[]{"Slow", "Default", "Fast", "Very Fast"};
    String[] countDisplayString = new String[]{"Low", "Default", "High", "Very High"};
    String[] rangeDisplayString = new String[]{"Default", "Far", "Very Far", "Extreme"};
    private Data _delay = new Data(30, 20, 10, 5);
    private Data _minSpawnDelay = new Data(300, 200, 100, 50);
    private Data _maxSpawnDelay = new Data(900, 800, 400, 100);
    private Data _spawnCount = new Data(2, 4, 6, 12);
    private Data _maxNearbyEntities = new Data(6, 6, 12, 24);
    private Data _requiredPlayerRange = new Data(16, 32, 64, 128);
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public SpawnerConfigGui(ITextComponent textComponent, AbstractSpawner logic, BlockPos pos) {
        super(textComponent);
        this.logic = logic;
        this.pos = pos;
        this.nbt = this.logic.func_189530_b(this.nbt);
        this.delay = this.nbt.func_74765_d("Delay");
        this.minSpawnDelay = this.nbt.func_74765_d("MinSpawnDelay");
        this.maxSpawnDelay = this.nbt.func_74765_d("MaxSpawnDelay");
        this.spawnCount = this.nbt.func_74765_d("SpawnCount");
        this.maxNearbyEntities = this.nbt.func_74765_d("MaxNearbyEntities");
        this.requiredPlayerRange = this.nbt.func_74765_d("RequiredPlayerRange");
        this.countOptionValue = this.loadOptionState(this.spawnCount, this._spawnCount);
        this.speedOptionValue = this.loadOptionState(this.minSpawnDelay, this._minSpawnDelay);
        this.rangeOptionValue = this.loadOptionState(this.requiredPlayerRange, this._requiredPlayerRange);
    }

    public void init() {
        this.countButton = new Button(this.width / 2 - 48, 65, 108, 20, "Count: " + this.countDisplayString[this.countOptionValue], button -> {
            switch (this.countOptionValue) {
                case 0: {
                    this.countOptionValue = 1;
                    this.spawnCount = this._spawnCount.DEFAULT;
                    this.maxNearbyEntities = this._maxNearbyEntities.DEFAULT;
                    break;
                }
                case 1: {
                    this.countOptionValue = 2;
                    this.spawnCount = this._spawnCount.HIGH;
                    this.maxNearbyEntities = this._maxNearbyEntities.HIGH;
                    break;
                }
                case 2: {
                    this.countOptionValue = 3;
                    this.spawnCount = this._spawnCount.HIGHEST;
                    this.maxNearbyEntities = this._maxNearbyEntities.HIGHEST;
                    break;
                }
                case 3: {
                    this.countOptionValue = 0;
                    this.spawnCount = this._spawnCount.LOW;
                    this.maxNearbyEntities = this._maxNearbyEntities.LOW;
                }
            }
            this.countButton.setMessage("Count: " + this.countDisplayString[this.countOptionValue]);
        });
        this.addButton((Widget)this.countButton);
        this.speedButton = new Button(this.width / 2 - 48, 90, 108, 20, "Speed: " + this.speedDisplayString[this.speedOptionValue], button -> {
            switch (this.speedOptionValue) {
                case 0: {
                    this.speedOptionValue = 1;
                    this.delay = this._delay.DEFAULT;
                    this.minSpawnDelay = this._minSpawnDelay.DEFAULT;
                    this.maxSpawnDelay = this._maxSpawnDelay.DEFAULT;
                    break;
                }
                case 1: {
                    this.speedOptionValue = 2;
                    this.delay = this._delay.HIGH;
                    this.minSpawnDelay = this._minSpawnDelay.HIGH;
                    this.maxSpawnDelay = this._maxSpawnDelay.HIGH;
                    break;
                }
                case 2: {
                    this.speedOptionValue = 3;
                    this.delay = this._delay.HIGHEST;
                    this.minSpawnDelay = this._minSpawnDelay.HIGHEST;
                    this.maxSpawnDelay = this._maxSpawnDelay.HIGHEST;
                    break;
                }
                case 3: {
                    this.speedOptionValue = 0;
                    this.delay = this._delay.LOW;
                    this.minSpawnDelay = this._minSpawnDelay.LOW;
                    this.maxSpawnDelay = this._maxSpawnDelay.LOW;
                }
            }
            this.speedButton.setMessage("Speed: " + this.speedDisplayString[this.speedOptionValue]);
        });
        this.addButton((Widget)this.speedButton);
        this.rangeButton = new Button(this.width / 2 - 48, 115, 108, 20, "Range: " + this.rangeDisplayString[this.rangeOptionValue] + " " + this.requiredPlayerRange, button -> {
            switch (this.rangeOptionValue) {
                case 0: {
                    this.rangeOptionValue = 1;
                    this.requiredPlayerRange = this._requiredPlayerRange.DEFAULT;
                    break;
                }
                case 1: {
                    this.rangeOptionValue = 2;
                    this.requiredPlayerRange = this._requiredPlayerRange.HIGH;
                    break;
                }
                case 2: {
                    this.rangeOptionValue = 3;
                    this.requiredPlayerRange = this._requiredPlayerRange.HIGHEST;
                    break;
                }
                case 3: {
                    this.rangeOptionValue = 0;
                    this.requiredPlayerRange = this._requiredPlayerRange.LOW;
                }
            }
            this.rangeButton.setMessage("Range: " + this.rangeDisplayString[this.rangeOptionValue] + " " + this.requiredPlayerRange);
        });
        this.addButton((Widget)this.rangeButton);
        this.addButton((Widget)new Button(this.width / 2 - 89, 190, 178, 20, "Save", button -> {
            this.configureSpawner();
            this.onClose();
        }));
        this.addButton((Widget)new Button(this.width / 2 - 89, 215, 178, 20, "Cancel", button -> this.onClose()));
        if (((Boolean)SpawnerModConfig.GENERAL.disable_count.get()).booleanValue()) {
            this.countButton.active = false;
            this.countButton.setMessage("Count disabled");
        }
        if (((Boolean)SpawnerModConfig.GENERAL.disable_speed.get()).booleanValue()) {
            this.speedButton.active = false;
            this.speedButton.setMessage("Speed disabled");
        }
        if (((Boolean)SpawnerModConfig.GENERAL.disable_range.get()).booleanValue()) {
            this.rangeButton.active = false;
            this.rangeButton.setMessage("Range disabled");
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground();
        this.minecraft.func_110434_K().func_110577_a(this.spawnerConfigTexture);
        SpawnerConfigGui.blit((int)(this.width / 2 - this.imageWidth / 2), (int)5, (float)0.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (int)this.imageWidth, (int)this.imageHeight);
        super.render(mouseX, mouseY, partialTicks);
    }

    private void configureSpawner() {
        SpawnerModPacketHandler.INSTANCE.sendToServer((Object)new SyncSpawnerMessage(this.pos, this.delay, this.spawnCount, this.requiredPlayerRange, this.maxNearbyEntities, this.minSpawnDelay, this.maxSpawnDelay));
    }

    private int loadOptionState(short current, Data reference) {
        if (current == reference.LOW) {
            return 0;
        }
        if (current == reference.DEFAULT) {
            return 1;
        }
        if (current == reference.HIGH) {
            return 2;
        }
        if (current == reference.HIGHEST) {
            return 3;
        }
        return 0;
    }

    private class Data {
        short LOW;
        short DEFAULT;
        short HIGH;
        short HIGHEST;

        public Data(int i, int j, int k, int l) {
            this.LOW = (short)i;
            this.DEFAULT = (short)j;
            this.HIGH = (short)k;
            this.HIGHEST = (short)l;
        }
    }
}

