/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class SpawnerModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();

    public static void sync(boolean disable_spawner_config, boolean disable_count, boolean disable_speed, boolean disable_range) {
        SpawnerModConfig.GENERAL.disable_spawner_config.set((Object)disable_spawner_config);
        SpawnerModConfig.GENERAL.disable_count.set((Object)disable_count);
        SpawnerModConfig.GENERAL.disable_speed.set((Object)disable_speed);
        SpawnerModConfig.GENERAL.disable_range.set((Object)disable_range);
    }

    public static class General {
        public final ForgeConfigSpec.DoubleValue monster_egg_drop_chance;
        public final ForgeConfigSpec.BooleanValue disable_silk_touch;
        public final ForgeConfigSpec.BooleanValue disable_spawner_config;
        public final ForgeConfigSpec.BooleanValue disable_count;
        public final ForgeConfigSpec.BooleanValue disable_speed;
        public final ForgeConfigSpec.BooleanValue disable_range;
        public final ForgeConfigSpec.BooleanValue disable_egg_removal_from_spawner;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("Drop rates");
            this.monster_egg_drop_chance = builder.comment("Drop chance for monster eggs. Value in percentage (%) ranging from 0 - 100. Default is 4.").translation("spawnermod.config.monster_egg_drop_chance").defineInRange("monster_egg_drop_chance", 4.0, 0.0, 100.0);
            builder.pop();
            builder.push("Monster Spawner");
            this.disable_spawner_config = builder.comment("Disable/Eanble the spawner config screen.").define("disable_spawner_config", false);
            this.disable_count = builder.comment("Disable/Eanble the Count option.").define("disable_count", false);
            this.disable_speed = builder.comment("Disable/Eanble the Speed option.").define("disable_speed", false);
            this.disable_range = builder.comment("Disable/Eanble the Range option.").define("disable_range", false);
            this.disable_egg_removal_from_spawner = builder.comment("Disable/Eanble the ability to right click the spawner for getting the monster egg.").define("disable_egg_removal_from_spawner", false);
            this.disable_silk_touch = builder.comment("Disable/Eanble the ability to silk touch a spawner.").translation("spawnermod.config.disable_silk_touch").define("disable_silk_touch", false);
            builder.pop();
        }
    }
}

