/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.gui;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.networking.packet.SyncSpawnerMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1917;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class SpawnerConfigGui
extends class_437 {
    private static final class_2588 titleText = new class_2588("gui.spawnermod.spawner_config_screen_title");
    private class_1917 logic;
    private class_2338 pos;
    private class_2487 nbt = new class_2487();
    private class_2960 spawnerConfigTexture = new class_2960("spawnermod", "textures/gui/spawner_config_screen.png");
    private int imageWidth = 178;
    private int imageHeight = 177;
    private class_2960 spawnsIconTexture = new class_2960("spawnermod", "textures/gui/spawner_config_screen_icon_spawns.png");
    private class_4185 countButton = null;
    private class_4185 speedButton = null;
    private class_4185 rangeButton = null;
    private class_4185 disableButton = null;
    private int countOptionValue;
    private int speedOptionValue;
    private int rangeOptionValue;
    String[] speedDisplayString = new String[]{"Slow", "Default", "Fast", "Very Fast"};
    String[] countDisplayString = new String[]{"Low", "Default", "High", "Very High"};
    String[] rangeDisplayString = new String[]{"Default", "Far", "Very Far", "Extreme"};
    String[] disableDisplayString = new String[]{"Enabled", "Disabled"};
    private Data _delay = new Data(30, 20, 10, 5);
    private Data _minSpawnDelay = new Data(300, 200, 100, 50);
    private Data _maxSpawnDelay = new Data(900, 800, 400, 100);
    private Data _spawnCount = new Data(2, 4, 6, 12);
    private Data _maxNearbyEntities = new Data(6, 6, 12, 24);
    private Data _requiredPlayerRange = new Data(16, 32, 64, 128);
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;
    private short spawnRange;
    private boolean disabled;
    private short spawns;
    private boolean cachedDisabled;
    private boolean limitedSpawns;

    public SpawnerConfigGui(class_2561 title, class_1917 logic, class_2338 pos) {
        super(title);
        this.logic = logic;
        this.pos = pos;
        this.nbt = this.logic.method_8272((class_1937)class_310.method_1551().field_1687, pos, this.nbt);
        this.delay = this.nbt.method_10568("Delay");
        this.minSpawnDelay = this.nbt.method_10568("MinSpawnDelay");
        this.maxSpawnDelay = this.nbt.method_10568("MaxSpawnDelay");
        this.spawnCount = this.nbt.method_10568("SpawnCount");
        this.maxNearbyEntities = this.nbt.method_10568("MaxNearbyEntities");
        this.requiredPlayerRange = this.nbt.method_10568("RequiredPlayerRange");
        this.spawnRange = this.nbt.method_10568("SpawnRange");
        if (this.spawnRange > 4) {
            this.cachedDisabled = this.disabled = true;
            this.requiredPlayerRange = this.spawnRange;
        } else {
            this.cachedDisabled = this.disabled = false;
        }
        this.countOptionValue = this.loadOptionState(this.spawnCount, this._spawnCount);
        this.speedOptionValue = this.loadOptionState(this.minSpawnDelay, this._minSpawnDelay);
        this.rangeOptionValue = this.loadOptionState(this.requiredPlayerRange, this._requiredPlayerRange);
        if (ConfigValues.get("limited_spawns_enabled") != 0) {
            this.limitedSpawns = true;
            if (this.nbt.method_10545("spawns")) {
                this.spawns = this.nbt.method_10568("spawns");
                if (ConfigValues.get("limited_spawns_amount") - this.spawns == 0) {
                    this.disabled = true;
                }
            }
        } else {
            this.limitedSpawns = false;
        }
    }

    protected void method_25426() {
        this.countButton = new class_4185(this.field_22789 / 2 - 48, 55, 108, 20, (class_2561)new class_2588("button.count." + this.getButtonText(this.countOptionValue)), button -> {
            switch (this.countOptionValue) {
                case 0: {
                    this.countOptionValue = 1;
                    this.spawnCount = this._spawnCount.DEFAULT;
                    this.maxNearbyEntities = this._maxNearbyEntities.DEFAULT;
                    break;
                }
                case 1: {
                    this.countOptionValue = 2;
                    this.spawnCount = this._spawnCount.HIGH;
                    this.maxNearbyEntities = this._maxNearbyEntities.HIGH;
                    break;
                }
                case 2: {
                    this.countOptionValue = 3;
                    this.spawnCount = this._spawnCount.HIGHEST;
                    this.maxNearbyEntities = this._maxNearbyEntities.HIGHEST;
                    break;
                }
                case 3: {
                    this.countOptionValue = 0;
                    this.spawnCount = this._spawnCount.LOW;
                    this.maxNearbyEntities = this._maxNearbyEntities.LOW;
                }
            }
            this.countButton.method_25355((class_2561)new class_2588("button.count." + this.getButtonText(this.countOptionValue)));
        });
        this.method_37063((class_364)this.countButton);
        this.speedButton = new class_4185(this.field_22789 / 2 - 48, 80, 108, 20, (class_2561)new class_2588("button.speed." + this.getButtonText(this.speedOptionValue)), button -> {
            switch (this.speedOptionValue) {
                case 0: {
                    this.speedOptionValue = 1;
                    this.delay = this._delay.DEFAULT;
                    this.minSpawnDelay = this._minSpawnDelay.DEFAULT;
                    this.maxSpawnDelay = this._maxSpawnDelay.DEFAULT;
                    break;
                }
                case 1: {
                    this.speedOptionValue = 2;
                    this.delay = this._delay.HIGH;
                    this.minSpawnDelay = this._minSpawnDelay.HIGH;
                    this.maxSpawnDelay = this._maxSpawnDelay.HIGH;
                    break;
                }
                case 2: {
                    this.speedOptionValue = 3;
                    this.delay = this._delay.HIGHEST;
                    this.minSpawnDelay = this._minSpawnDelay.HIGHEST;
                    this.maxSpawnDelay = this._maxSpawnDelay.HIGHEST;
                    break;
                }
                case 3: {
                    this.speedOptionValue = 0;
                    this.delay = this._delay.LOW;
                    this.minSpawnDelay = this._minSpawnDelay.LOW;
                    this.maxSpawnDelay = this._maxSpawnDelay.LOW;
                }
            }
            this.speedButton.method_25355((class_2561)new class_2588("button.speed." + this.getButtonText(this.speedOptionValue)));
        });
        this.method_37063((class_364)this.speedButton);
        this.rangeButton = new class_4185(this.field_22789 / 2 - 48, 105, 108, 20, (class_2561)new class_2588("button.range." + this.getButtonText(this.rangeOptionValue)), button -> {
            switch (this.rangeOptionValue) {
                case 0: {
                    this.rangeOptionValue = 1;
                    this.requiredPlayerRange = this._requiredPlayerRange.DEFAULT;
                    break;
                }
                case 1: {
                    this.rangeOptionValue = 2;
                    this.requiredPlayerRange = this._requiredPlayerRange.HIGH;
                    break;
                }
                case 2: {
                    this.rangeOptionValue = 3;
                    this.requiredPlayerRange = this._requiredPlayerRange.HIGHEST;
                    break;
                }
                case 3: {
                    this.rangeOptionValue = 0;
                    this.requiredPlayerRange = this._requiredPlayerRange.LOW;
                }
            }
            this.rangeButton.method_25355((class_2561)new class_2588("button.range." + this.getButtonText(this.rangeOptionValue)));
        });
        this.method_37063((class_364)this.rangeButton);
        this.disableButton = new class_4185(this.field_22789 / 2 - 48, 130, 108, 20, (class_2561)new class_2588("button.toggle." + this.getButtonText(this.disabled)), button -> {
            if (this.disabled) {
                this.disabled = false;
                this.toggleButtons(true);
                switch (this.rangeOptionValue) {
                    case 0: {
                        this.requiredPlayerRange = this._requiredPlayerRange.LOW;
                        break;
                    }
                    case 1: {
                        this.requiredPlayerRange = this._requiredPlayerRange.DEFAULT;
                        break;
                    }
                    case 2: {
                        this.requiredPlayerRange = this._requiredPlayerRange.HIGH;
                        break;
                    }
                    case 3: {
                        this.requiredPlayerRange = this._requiredPlayerRange.HIGHEST;
                    }
                }
            } else {
                this.disabled = true;
                this.toggleButtons(false);
                this.requiredPlayerRange = 0;
            }
            this.disableButton.method_25355((class_2561)new class_2588("button.toggle." + this.getButtonText(this.disabled)));
        });
        this.method_37063((class_364)this.disableButton);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 89, 190, 178, 20, (class_2561)new class_2588("button.save"), button -> {
            this.configureSpawner();
            this.close();
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 89, 215, 178, 20, (class_2561)new class_2588("button.cancel"), button -> this.close()));
        if (this.disabled) {
            this.toggleButtons(false);
        } else {
            this.toggleButtons(true);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_25420(matrices);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.spawnerConfigTexture);
        SpawnerConfigGui.method_25290((class_4587)matrices, (int)(this.field_22789 / 2 - this.imageWidth / 2), (int)5, (float)0.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (int)this.imageWidth, (int)this.imageHeight);
        int length = titleText.getString().length() * 2;
        SpawnerConfigGui.method_27535((class_4587)matrices, (class_327)this.field_22787.field_1772, (class_2561)titleText, (int)(this.field_22789 / 2 - length - 3), (int)33, (int)16767332);
        if (this.limitedSpawns) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.spawnsIconTexture);
            SpawnerConfigGui.method_25290((class_4587)matrices, (int)(this.field_22789 / 2 - 7 + 101), (int)23, (float)0.0f, (float)0.0f, (int)14, (int)14, (int)14, (int)14);
            SpawnerConfigGui.method_27535((class_4587)matrices, (class_327)this.field_22787.field_1772, (class_2561)new class_2585("" + (ConfigValues.get("limited_spawns_amount") - this.spawns)), (int)(this.field_22789 / 2 + 114), (int)27, (int)0xFFFFFF);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void close() {
        this.field_22787.method_1507((class_437)null);
    }

    private void configureSpawner() {
        if (this.cachedDisabled && this.cachedDisabled == this.disabled) {
            return;
        }
        new SyncSpawnerMessage(this.pos, this.delay, this.spawnCount, this.requiredPlayerRange, this.maxNearbyEntities, this.minSpawnDelay, this.maxSpawnDelay).send();
    }

    private String getButtonText(int optionValue) {
        switch (optionValue) {
            case 0: {
                return "low";
            }
            case 1: {
                return "default";
            }
            case 2: {
                return "high";
            }
            case 3: {
                return "very_high";
            }
        }
        return "default";
    }

    private String getButtonText(boolean disabled) {
        if (disabled) {
            return "disabled";
        }
        return "enabled";
    }

    private int loadOptionState(short current, Data reference) {
        if (current == reference.LOW) {
            return 0;
        }
        if (current == reference.DEFAULT) {
            return 1;
        }
        if (current == reference.HIGH) {
            return 2;
        }
        if (current == reference.HIGHEST) {
            return 3;
        }
        return 0;
    }

    private void toggleButtons(boolean state) {
        if (ConfigValues.get("disable_count") != 0) {
            this.countButton.field_22763 = false;
            this.countButton.method_25355((class_2561)new class_2588("button.count.disabled"));
        } else {
            this.countButton.field_22763 = state;
        }
        if (ConfigValues.get("disable_speed") != 0) {
            this.speedButton.field_22763 = false;
            this.speedButton.method_25355((class_2561)new class_2588("button.speed.disabled"));
        } else {
            this.speedButton.field_22763 = state;
        }
        if (ConfigValues.get("disable_range") != 0) {
            this.rangeButton.field_22763 = false;
            this.rangeButton.method_25355((class_2561)new class_2588("button.range.disabled"));
        } else {
            this.rangeButton.field_22763 = state;
        }
    }

    private class Data {
        short LOW;
        short DEFAULT;
        short HIGH;
        short HIGHEST;

        public Data(int i, int j, int k, int l) {
            this.LOW = (short)i;
            this.DEFAULT = (short)j;
            this.HIGH = (short)k;
            this.HIGHEST = (short)l;
        }
    }
}

