/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.item;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.gui.SpawnerConfigGui;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnerKeyItem
extends Item {
    private static final TranslationTextComponent textComponent = new TranslationTextComponent("tooltip.spawnermod.spawner_key_disabled");

    public SpawnerKeyItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (ConfigValues.get("disable_spawner_config") == 1) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            return ActionResultType.PASS;
        }
        BlockPos blockpos = context.func_195995_a();
        if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150474_ac) {
            return ActionResultType.PASS;
        }
        MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)world.func_175625_s(blockpos);
        AbstractSpawner logic = spawner.func_145881_a();
        this.openSpawnerGui(logic, blockpos);
        return super.onItemUseFirst(stack, context);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (ConfigValues.get("disable_spawner_config") == 1) {
            tooltip.add((ITextComponent)textComponent.func_240699_a_(TextFormatting.RED));
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openSpawnerGui(AbstractSpawner logic, BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new SpawnerConfigGui((ITextComponent)new TranslationTextComponent(""), logic, pos));
    }
}

