/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.mixin;

import com.branders.spawnermod.config.ConfigValues;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSpawner.class})
public class LimitedSpawnsMixin {
    private short spawns = 0;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/World;levelEvent(ILnet/minecraft/util/math/BlockPos;I)V")}, method={"tick()V"}, cancellable=true)
    private void entitySpawn(CallbackInfo ci) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt = ((AbstractSpawner)this).func_189530_b(nbt);
        String entity_string = nbt.func_74781_a("SpawnData").toString();
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).contains("area_effect_cloud")) {
            return;
        }
        this.spawns = (short)(this.spawns + 1);
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/EntityType;by(Lnet/minecraft/nbt/CompoundNBT;)Ljava/util/Optional;")}, method={"tick()V"}, cancellable=true)
    private void cancel(CallbackInfo ci) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        AbstractSpawner logic = (AbstractSpawner)this;
        BlockPos pos = logic.func_177221_b();
        World world = logic.func_98271_a();
        world.func_175625_s(pos).func_70296_d();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        if (this.spawns >= ConfigValues.get("limited_spawns_amount")) {
            CompoundNBT nbt = new CompoundNBT();
            nbt = logic.func_189530_b(nbt);
            nbt.func_74777_a("RequiredPlayerRange", (short)0);
            logic.func_98270_a(nbt);
            logic.func_200876_a(EntityType.field_200788_b);
            world.func_217379_c(1501, pos, 0);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;getShort(Ljava/lang/String;)S")}, method={"load"})
    private void load(CompoundNBT nbt, CallbackInfo info) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        this.spawns = nbt.func_74765_d("spawns");
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;putShort(Ljava/lang/String;S)V")}, method={"save"})
    private void save(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> info) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        nbt.func_74777_a("spawns", this.spawns);
    }
}

