/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.config.ModConfigManager;
import com.branders.spawnermod.event.SpawnerEventHandler;
import com.branders.spawnermod.item.SpawnerKeyItem;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="spawnermod")
public class SpawnerMod {
    public static final String MODID = "spawnermod";
    public static final Logger LOGGER = LogManager.getLogger((String)"spawnermod");
    public static Item iron_golem_spawn_egg = new SpawnEggItem(EntityType.f_20460_, 0xE7E7E7, 9794134, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));

    public SpawnerMod() {
        SpawnerModPacketHandler.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientStarting);
        MinecraftForge.EVENT_BUS.register((Object)new SpawnerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientStarting(FMLClientSetupEvent event) {
        ModConfigManager.initConfig(MODID, Minecraft.m_91087_().f_91069_.getAbsoluteFile());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        ModConfigManager.initConfig(MODID, event.getServer().m_6237_().getAbsoluteFile());
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        SpawnerModPacketHandler.INSTANCE.sendTo((Object)new SyncSpawnerConfig(ConfigValues.get("disable_spawner_config"), ConfigValues.get("disable_count"), ConfigValues.get("disable_speed"), ConfigValues.get("disable_range")), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SpawnerMod.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)((Item)new SpawnerKeyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41503_(10).m_41497_(Rarity.RARE)).setRegistryName(MODID, "spawner_key")));
        registry.register((IForgeRegistryEntry)((Item)iron_golem_spawn_egg.setRegistryName(MODID, "iron_golem_spawn_egg")));
        registry.register((IForgeRegistryEntry)((Item)new BlockItem(Blocks.f_50085_, new Item.Properties().m_41491_(CreativeModeTab.f_40750_).m_41497_(Rarity.EPIC)).setRegistryName(Blocks.f_50085_.getRegistryName())));
    }
}

