/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.gui;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BaseSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpawnerConfigGui
extends Screen {
    private static final TranslatableComponent textComponent = new TranslatableComponent("gui.spawnermod.spawner_config_screen_title");
    private Minecraft minecraft = Minecraft.m_91087_();
    private BaseSpawner logic;
    private BlockPos pos;
    private CompoundTag nbt = new CompoundTag();
    private ResourceLocation spawnerConfigTexture = new ResourceLocation("spawnermod", "/textures/gui/spawner_config_screen.png");
    private int imageWidth = 178;
    private int imageHeight = 177;
    private Button countButton = null;
    private Button speedButton = null;
    private Button rangeButton = null;
    private Button disableButton = null;
    private int countOptionValue;
    private int speedOptionValue;
    private int rangeOptionValue;
    String[] speedDisplayString = new String[]{"Slow", "Default", "Fast", "Very Fast"};
    String[] countDisplayString = new String[]{"Low", "Default", "High", "Very High"};
    String[] rangeDisplayString = new String[]{"Default", "Far", "Very Far", "Extreme"};
    String[] disableDisplayString = new String[]{"Enabled", "Disabled"};
    private Data _delay = new Data(30, 20, 10, 5);
    private Data _minSpawnDelay = new Data(300, 200, 100, 50);
    private Data _maxSpawnDelay = new Data(900, 800, 400, 100);
    private Data _spawnCount = new Data(2, 4, 6, 12);
    private Data _maxNearbyEntities = new Data(6, 6, 12, 24);
    private Data _requiredPlayerRange = new Data(16, 32, 64, 128);
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;
    private short spawnRange;
    private boolean disabled;
    private boolean cachedDisabled;

    public SpawnerConfigGui(Component textComponent, BaseSpawner logic, BlockPos pos) {
        super(textComponent);
        this.logic = logic;
        this.pos = pos;
        this.nbt = this.logic.m_151339_(null, pos, this.nbt);
        this.delay = this.nbt.m_128448_("Delay");
        this.minSpawnDelay = this.nbt.m_128448_("MinSpawnDelay");
        this.maxSpawnDelay = this.nbt.m_128448_("MaxSpawnDelay");
        this.spawnCount = this.nbt.m_128448_("SpawnCount");
        this.maxNearbyEntities = this.nbt.m_128448_("MaxNearbyEntities");
        this.requiredPlayerRange = this.nbt.m_128448_("RequiredPlayerRange");
        this.spawnRange = this.nbt.m_128448_("SpawnRange");
        if (this.spawnRange > 4) {
            this.cachedDisabled = this.disabled = true;
            this.requiredPlayerRange = this.spawnRange;
        } else {
            this.cachedDisabled = this.disabled = false;
        }
        this.countOptionValue = this.loadOptionState(this.spawnCount, this._spawnCount);
        this.speedOptionValue = this.loadOptionState(this.minSpawnDelay, this._minSpawnDelay);
        this.rangeOptionValue = this.loadOptionState(this.requiredPlayerRange, this._requiredPlayerRange);
    }

    public void m_7856_() {
        this.countButton = new Button(this.f_96543_ / 2 - 48, 55, 108, 20, (Component)new TranslatableComponent("button.count." + this.getButtonText(this.countOptionValue)), button -> {
            switch (this.countOptionValue) {
                case 0: {
                    this.countOptionValue = 1;
                    this.spawnCount = this._spawnCount.DEFAULT;
                    this.maxNearbyEntities = this._maxNearbyEntities.DEFAULT;
                    break;
                }
                case 1: {
                    this.countOptionValue = 2;
                    this.spawnCount = this._spawnCount.HIGH;
                    this.maxNearbyEntities = this._maxNearbyEntities.HIGH;
                    break;
                }
                case 2: {
                    this.countOptionValue = 3;
                    this.spawnCount = this._spawnCount.HIGHEST;
                    this.maxNearbyEntities = this._maxNearbyEntities.HIGHEST;
                    break;
                }
                case 3: {
                    this.countOptionValue = 0;
                    this.spawnCount = this._spawnCount.LOW;
                    this.maxNearbyEntities = this._maxNearbyEntities.LOW;
                }
            }
            this.countButton.m_93666_((Component)new TranslatableComponent("button.count." + this.getButtonText(this.countOptionValue)));
        });
        this.m_142416_((GuiEventListener)this.countButton);
        this.speedButton = new Button(this.f_96543_ / 2 - 48, 80, 108, 20, (Component)new TranslatableComponent("button.speed." + this.getButtonText(this.speedOptionValue)), button -> {
            switch (this.speedOptionValue) {
                case 0: {
                    this.speedOptionValue = 1;
                    this.delay = this._delay.DEFAULT;
                    this.minSpawnDelay = this._minSpawnDelay.DEFAULT;
                    this.maxSpawnDelay = this._maxSpawnDelay.DEFAULT;
                    break;
                }
                case 1: {
                    this.speedOptionValue = 2;
                    this.delay = this._delay.HIGH;
                    this.minSpawnDelay = this._minSpawnDelay.HIGH;
                    this.maxSpawnDelay = this._maxSpawnDelay.HIGH;
                    break;
                }
                case 2: {
                    this.speedOptionValue = 3;
                    this.delay = this._delay.HIGHEST;
                    this.minSpawnDelay = this._minSpawnDelay.HIGHEST;
                    this.maxSpawnDelay = this._maxSpawnDelay.HIGHEST;
                    break;
                }
                case 3: {
                    this.speedOptionValue = 0;
                    this.delay = this._delay.LOW;
                    this.minSpawnDelay = this._minSpawnDelay.LOW;
                    this.maxSpawnDelay = this._maxSpawnDelay.LOW;
                }
            }
            this.speedButton.m_93666_((Component)new TranslatableComponent("button.speed." + this.getButtonText(this.speedOptionValue)));
        });
        this.m_142416_((GuiEventListener)this.speedButton);
        this.rangeButton = new Button(this.f_96543_ / 2 - 48, 105, 108, 20, (Component)new TranslatableComponent("button.range." + this.getButtonText(this.rangeOptionValue)), button -> {
            switch (this.rangeOptionValue) {
                case 0: {
                    this.rangeOptionValue = 1;
                    this.requiredPlayerRange = this._requiredPlayerRange.DEFAULT;
                    break;
                }
                case 1: {
                    this.rangeOptionValue = 2;
                    this.requiredPlayerRange = this._requiredPlayerRange.HIGH;
                    break;
                }
                case 2: {
                    this.rangeOptionValue = 3;
                    this.requiredPlayerRange = this._requiredPlayerRange.HIGHEST;
                    break;
                }
                case 3: {
                    this.rangeOptionValue = 0;
                    this.requiredPlayerRange = this._requiredPlayerRange.LOW;
                }
            }
            this.rangeButton.m_93666_((Component)new TranslatableComponent("button.range." + this.getButtonText(this.rangeOptionValue)));
        });
        this.m_142416_((GuiEventListener)this.rangeButton);
        this.disableButton = new Button(this.f_96543_ / 2 - 48, 130, 108, 20, (Component)new TranslatableComponent("button.toggle." + this.getButtonText(this.disabled)), button -> {
            if (this.disabled) {
                this.disabled = false;
                this.toggleButtons(true);
                switch (this.rangeOptionValue) {
                    case 0: {
                        this.requiredPlayerRange = this._requiredPlayerRange.LOW;
                        break;
                    }
                    case 1: {
                        this.requiredPlayerRange = this._requiredPlayerRange.DEFAULT;
                        break;
                    }
                    case 2: {
                        this.requiredPlayerRange = this._requiredPlayerRange.HIGH;
                        break;
                    }
                    case 3: {
                        this.requiredPlayerRange = this._requiredPlayerRange.HIGHEST;
                    }
                }
            } else {
                this.disabled = true;
                this.toggleButtons(false);
                this.requiredPlayerRange = 0;
            }
            this.disableButton.m_93666_((Component)new TranslatableComponent("button.toggle." + this.getButtonText(this.disabled)));
        });
        this.m_142416_((GuiEventListener)this.disableButton);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 89, 190, 178, 20, (Component)new TranslatableComponent("button.save"), button -> {
            this.configureSpawner();
            this.close();
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 89, 215, 178, 20, (Component)new TranslatableComponent("button.cancel"), button -> this.close()));
        if (this.disabled) {
            this.toggleButtons(false);
        } else {
            this.toggleButtons(true);
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.spawnerConfigTexture);
        SpawnerConfigGui.m_93133_((PoseStack)matrixStack, (int)(this.f_96543_ / 2 - this.imageWidth / 2), (int)5, (float)0.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (int)this.imageWidth, (int)this.imageHeight);
        int length = textComponent.getString().length() * 2;
        SpawnerConfigGui.m_93243_((PoseStack)matrixStack, (Font)this.minecraft.f_91062_, (Component)textComponent, (int)(this.f_96543_ / 2 - length - 3), (int)33, (int)16767332);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void close() {
        this.minecraft.m_91152_((Screen)null);
    }

    private void configureSpawner() {
        if (this.cachedDisabled && this.cachedDisabled == this.disabled) {
            return;
        }
        SpawnerModPacketHandler.INSTANCE.sendToServer((Object)new SyncSpawnerMessage(this.pos, this.delay, this.spawnCount, this.requiredPlayerRange, this.maxNearbyEntities, this.minSpawnDelay, this.maxSpawnDelay));
    }

    private String getButtonText(int optionValue) {
        switch (optionValue) {
            case 0: {
                return "low";
            }
            case 1: {
                return "default";
            }
            case 2: {
                return "high";
            }
            case 3: {
                return "very_high";
            }
        }
        return "default";
    }

    private String getButtonText(boolean disabled) {
        if (disabled) {
            return "disabled";
        }
        return "enabled";
    }

    private int loadOptionState(short current, Data reference) {
        if (current == reference.LOW) {
            return 0;
        }
        if (current == reference.DEFAULT) {
            return 1;
        }
        if (current == reference.HIGH) {
            return 2;
        }
        if (current == reference.HIGHEST) {
            return 3;
        }
        return 0;
    }

    private void toggleButtons(boolean state) {
        if (ConfigValues.get("disable_count") != 0) {
            this.countButton.f_93623_ = false;
            this.countButton.m_93666_((Component)new TranslatableComponent("button.count.disabled"));
        } else {
            this.countButton.f_93623_ = state;
        }
        if (ConfigValues.get("disable_speed") != 0) {
            this.speedButton.f_93623_ = false;
            this.speedButton.m_93666_((Component)new TranslatableComponent("button.speed.disabled"));
        } else {
            this.speedButton.f_93623_ = state;
        }
        if (ConfigValues.get("disable_range") != 0) {
            this.rangeButton.f_93623_ = false;
            this.rangeButton.m_93666_((Component)new TranslatableComponent("button.range.disabled"));
        } else {
            this.rangeButton.f_93623_ = state;
        }
    }

    private class Data {
        short LOW;
        short DEFAULT;
        short HIGH;
        short HIGHEST;

        public Data(int i, int j, int k, int l) {
            this.LOW = (short)i;
            this.DEFAULT = (short)j;
            this.HIGH = (short)k;
            this.HIGHEST = (short)l;
        }
    }
}

