/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.config.SpawnConfig;
import com.branders.spawnermod.gui.SpawnerConfigGui;
import com.branders.spawnermod.item.SpawnerKeyItem;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnerEventHandler {
    private float SPAWN_RATE = (float)((Integer)SpawnConfig.monster_egg_drop_chance.get()).intValue() / 100.0f;
    private Random random = new Random();
    private EntityType<?> defaultEntityType = EntityType.field_200788_b;

    @SubscribeEvent
    public void onBlockHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        NBTTagList list;
        if (event.getState().func_177230_c() == Blocks.field_150474_ac && this.checkSilkTouch(list = event.getHarvester().func_184614_ca().func_77986_q())) {
            event.getDrops().add(new ItemStack((IItemProvider)Blocks.field_150474_ac, 1));
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        NBTTagList list;
        if (event.getState().func_177230_c() == Blocks.field_150474_ac && this.checkSilkTouch(list = event.getPlayer().func_184614_ca().func_77986_q())) {
            event.setExpToDrop(0);
        }
    }

    @SubscribeEvent
    public void onNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        World world = (World)event.getWorld();
        BlockPos blockpos = event.getPos();
        IBlockState iblockstate = world.func_180495_p(blockpos);
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(blockpos);
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        logic.func_200876_a(this.defaultEntityType);
        spawner.func_70296_d();
        world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (this.random.nextFloat() > this.SPAWN_RATE) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType entityType = entity.func_200600_R();
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entityType.getRegistryName() + "_spawn_egg")));
        event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (event.getItemStack().func_77973_b() instanceof ItemBlock || event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        BlockPos blockpos = event.getPos();
        IBlockState iblockstate = world.func_180495_p(blockpos);
        if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150474_ac) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof SpawnerKeyItem) {
            if (!world.field_72995_K) {
                return;
            }
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(blockpos);
            MobSpawnerBaseLogic logic = spawner.func_145881_a();
            this.openSpawnerGui(logic, blockpos);
        } else {
            if (world.field_72995_K) {
                return;
            }
            this.dropMonsterEgg(world, blockpos, iblockstate);
        }
    }

    private void dropMonsterEgg(World world, BlockPos blockpos, IBlockState iblockstate) {
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(blockpos);
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        NBTTagCompound nbtIn = new NBTTagCompound();
        nbtIn = logic.func_189530_b(nbtIn);
        String entity_string = nbtIn.func_74781_a("SpawnData").func_150285_a_();
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        EntityType entityType = EntityType.func_200713_a((String)(entity_string = entity_string.substring(0, entity_string.indexOf("\""))));
        if (entityType.equals(this.defaultEntityType)) {
            return;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entity_string + "_spawn_egg")));
        double d0 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.06f + 0.6;
        double d2 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
        EntityItem entityItem = new EntityItem(world, (double)blockpos.func_177958_n() + d0, (double)blockpos.func_177956_o() + d1, (double)blockpos.func_177952_p() + d2, itemStack);
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
        logic.func_200876_a(this.defaultEntityType);
        spawner.func_70296_d();
        world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
    }

    private boolean checkSilkTouch(NBTTagList list) {
        return list.func_150285_a_().indexOf("minecraft:silk_touch") != -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openSpawnerGui(MobSpawnerBaseLogic logic, BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_152344_a(() -> mc.func_147108_a((GuiScreen)new SpawnerConfigGui(logic, pos)));
    }
}

