/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.gui;

import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerMessage;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class SpawnerConfigGui
extends GuiScreen {
    private MobSpawnerBaseLogic logic;
    private BlockPos pos;
    private NBTTagCompound nbt = new NBTTagCompound();
    private ResourceLocation spawnerConfigTexture = new ResourceLocation("spawnermod", "/textures/gui/spawner_config_screen.png");
    private int imageWidth = 178;
    private int imageHeight = 177;
    private GuiButton countButton;
    private GuiButton speedButton;
    private GuiButton rangeButton;
    private int countOptionValue;
    private int speedOptionValue;
    private int rangeOptionValue;
    String[] speedDisplayString = new String[]{"Slow", "Default", "Fast", "Very Fast"};
    String[] countDisplayString = new String[]{"Low", "Default", "High", "Very High"};
    String[] rangeDisplayString = new String[]{"Default", "Far", "Very Far", "Extreme"};
    private Data _delay = new Data(30, 20, 10, 5);
    private Data _minSpawnDelay = new Data(300, 200, 100, 50);
    private Data _maxSpawnDelay = new Data(900, 800, 400, 100);
    private Data _spawnCount = new Data(2, 4, 6, 12);
    private Data _maxNearbyEntities = new Data(6, 6, 12, 24);
    private Data _requiredPlayerRange = new Data(16, 32, 64, 128);
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public SpawnerConfigGui(MobSpawnerBaseLogic logic, BlockPos pos) {
        this.logic = logic;
        this.pos = pos;
        this.nbt = this.logic.func_189530_b(this.nbt);
        this.delay = this.nbt.func_74765_d("Delay");
        this.minSpawnDelay = this.nbt.func_74765_d("MinSpawnDelay");
        this.maxSpawnDelay = this.nbt.func_74765_d("MaxSpawnDelay");
        this.spawnCount = this.nbt.func_74765_d("SpawnCount");
        this.maxNearbyEntities = this.nbt.func_74765_d("MaxNearbyEntities");
        this.requiredPlayerRange = this.nbt.func_74765_d("RequiredPlayerRange");
        this.countOptionValue = this.loadOptionState(this.spawnCount, this._spawnCount);
        this.speedOptionValue = this.loadOptionState(this.minSpawnDelay, this._minSpawnDelay);
        this.rangeOptionValue = this.loadOptionState(this.requiredPlayerRange, this._requiredPlayerRange);
    }

    protected void func_73866_w_() {
        this.countButton = new GuiButton(0, this.field_146294_l / 2 - 48, 65, 96, 20, "Count: " + this.countDisplayString[this.countOptionValue]){

            public void func_194829_a(double mouseX, double mouseY) {
                switch (SpawnerConfigGui.this.countOptionValue) {
                    case 0: {
                        SpawnerConfigGui.this.countOptionValue = 1;
                        SpawnerConfigGui.this.spawnCount = ((SpawnerConfigGui)SpawnerConfigGui.this)._spawnCount.DEFAULT;
                        SpawnerConfigGui.this.maxNearbyEntities = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxNearbyEntities.DEFAULT;
                        break;
                    }
                    case 1: {
                        SpawnerConfigGui.this.countOptionValue = 2;
                        SpawnerConfigGui.this.spawnCount = ((SpawnerConfigGui)SpawnerConfigGui.this)._spawnCount.HIGH;
                        SpawnerConfigGui.this.maxNearbyEntities = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxNearbyEntities.HIGH;
                        break;
                    }
                    case 2: {
                        SpawnerConfigGui.this.countOptionValue = 3;
                        SpawnerConfigGui.this.spawnCount = ((SpawnerConfigGui)SpawnerConfigGui.this)._spawnCount.HIGHEST;
                        SpawnerConfigGui.this.maxNearbyEntities = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxNearbyEntities.HIGHEST;
                        break;
                    }
                    case 3: {
                        SpawnerConfigGui.this.countOptionValue = 0;
                        SpawnerConfigGui.this.spawnCount = ((SpawnerConfigGui)SpawnerConfigGui.this)._spawnCount.LOW;
                        SpawnerConfigGui.this.maxNearbyEntities = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxNearbyEntities.LOW;
                    }
                }
                ((SpawnerConfigGui)SpawnerConfigGui.this).countButton.field_146126_j = "Count: " + SpawnerConfigGui.this.countDisplayString[SpawnerConfigGui.this.countOptionValue];
            }
        };
        this.func_189646_b(this.countButton);
        this.speedButton = new GuiButton(0, this.field_146294_l / 2 - 48, 90, 96, 20, "Speed: " + this.speedDisplayString[this.speedOptionValue]){

            public void func_194829_a(double mouseX, double mouseY) {
                switch (SpawnerConfigGui.this.speedOptionValue) {
                    case 0: {
                        SpawnerConfigGui.this.speedOptionValue = 1;
                        SpawnerConfigGui.this.delay = ((SpawnerConfigGui)SpawnerConfigGui.this)._delay.DEFAULT;
                        SpawnerConfigGui.this.minSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._minSpawnDelay.DEFAULT;
                        SpawnerConfigGui.this.maxSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxSpawnDelay.DEFAULT;
                        break;
                    }
                    case 1: {
                        SpawnerConfigGui.this.speedOptionValue = 2;
                        SpawnerConfigGui.this.delay = ((SpawnerConfigGui)SpawnerConfigGui.this)._delay.HIGH;
                        SpawnerConfigGui.this.minSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._minSpawnDelay.HIGH;
                        SpawnerConfigGui.this.maxSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxSpawnDelay.HIGH;
                        break;
                    }
                    case 2: {
                        SpawnerConfigGui.this.speedOptionValue = 3;
                        SpawnerConfigGui.this.delay = ((SpawnerConfigGui)SpawnerConfigGui.this)._delay.HIGHEST;
                        SpawnerConfigGui.this.minSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._minSpawnDelay.HIGHEST;
                        SpawnerConfigGui.this.maxSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxSpawnDelay.HIGHEST;
                        break;
                    }
                    case 3: {
                        SpawnerConfigGui.this.speedOptionValue = 0;
                        SpawnerConfigGui.this.delay = ((SpawnerConfigGui)SpawnerConfigGui.this)._delay.LOW;
                        SpawnerConfigGui.this.minSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._minSpawnDelay.LOW;
                        SpawnerConfigGui.this.maxSpawnDelay = ((SpawnerConfigGui)SpawnerConfigGui.this)._maxSpawnDelay.LOW;
                    }
                }
                ((SpawnerConfigGui)SpawnerConfigGui.this).speedButton.field_146126_j = "Speed: " + SpawnerConfigGui.this.speedDisplayString[SpawnerConfigGui.this.speedOptionValue];
            }
        };
        this.func_189646_b(this.speedButton);
        this.rangeButton = new GuiButton(0, this.field_146294_l / 2 - 48, 115, 96, 20, "Range: " + this.rangeDisplayString[this.rangeOptionValue]){

            public void func_194829_a(double mouseX, double mouseY) {
                switch (SpawnerConfigGui.this.rangeOptionValue) {
                    case 0: {
                        SpawnerConfigGui.this.rangeOptionValue = 1;
                        SpawnerConfigGui.this.requiredPlayerRange = ((SpawnerConfigGui)SpawnerConfigGui.this)._requiredPlayerRange.DEFAULT;
                        break;
                    }
                    case 1: {
                        SpawnerConfigGui.this.rangeOptionValue = 2;
                        SpawnerConfigGui.this.requiredPlayerRange = ((SpawnerConfigGui)SpawnerConfigGui.this)._requiredPlayerRange.HIGH;
                        break;
                    }
                    case 2: {
                        SpawnerConfigGui.this.rangeOptionValue = 3;
                        SpawnerConfigGui.this.requiredPlayerRange = ((SpawnerConfigGui)SpawnerConfigGui.this)._requiredPlayerRange.HIGHEST;
                        break;
                    }
                    case 3: {
                        SpawnerConfigGui.this.rangeOptionValue = 0;
                        SpawnerConfigGui.this.requiredPlayerRange = ((SpawnerConfigGui)SpawnerConfigGui.this)._requiredPlayerRange.LOW;
                    }
                }
                ((SpawnerConfigGui)SpawnerConfigGui.this).rangeButton.field_146126_j = "Range: " + SpawnerConfigGui.this.rangeDisplayString[SpawnerConfigGui.this.rangeOptionValue];
            }
        };
        this.func_189646_b(this.rangeButton);
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 89, 190, 178, 20, "Save"){

            public void func_194829_a(double mouseX, double mouseY) {
                SpawnerConfigGui.this.configureSpawner();
                SpawnerConfigGui.this.func_195122_V_();
            }
        });
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 89, 215, 178, 20, "Cancel"){

            public void func_194829_a(double mouseX, double mouseY) {
                SpawnerConfigGui.this.func_195122_V_();
            }
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(this.spawnerConfigTexture);
        SpawnerConfigGui.func_146110_a((int)(this.field_146294_l / 2 - this.imageWidth / 2), (int)5, (float)0.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (float)this.imageWidth, (float)this.imageHeight);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void configureSpawner() {
        SpawnerModPacketHandler.INSTANCE.sendToServer((Object)new SyncSpawnerMessage(this.pos, this.delay, this.spawnCount, this.requiredPlayerRange, this.maxNearbyEntities, this.minSpawnDelay, this.maxSpawnDelay));
    }

    private int loadOptionState(short current, Data reference) {
        if (current == reference.LOW) {
            return 0;
        }
        if (current == reference.DEFAULT) {
            return 1;
        }
        if (current == reference.HIGH) {
            return 2;
        }
        if (current == reference.HIGHEST) {
            return 3;
        }
        return 0;
    }

    private class Data {
        short LOW;
        short DEFAULT;
        short HIGH;
        short HIGHEST;

        public Data(int i, int j, int k, int l) {
            this.LOW = (short)i;
            this.DEFAULT = (short)j;
            this.HIGH = (short)k;
            this.HIGHEST = (short)l;
        }
    }
}

