/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.networking.packet;

import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncSpawnerMessage {
    private final BlockPos pos;
    private short delay;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short spawnCount;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public SyncSpawnerMessage(BlockPos pos, short delay, short spawnCount, short requiredPlayerRange, short maxNearbyEntities, short minSpawnDelay, short maxSpawnDelay) {
        this.pos = pos;
        this.delay = delay;
        this.minSpawnDelay = minSpawnDelay;
        this.maxSpawnDelay = maxSpawnDelay;
        this.spawnCount = spawnCount;
        this.maxNearbyEntities = maxNearbyEntities;
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public static void encode(SyncSpawnerMessage msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeShort((int)msg.delay);
        buf.writeShort((int)msg.maxNearbyEntities);
        buf.writeShort((int)msg.maxSpawnDelay);
        buf.writeShort((int)msg.minSpawnDelay);
        buf.writeShort((int)msg.requiredPlayerRange);
        buf.writeShort((int)msg.spawnCount);
    }

    public static SyncSpawnerMessage decode(PacketBuffer buf) {
        BlockPos pos = new BlockPos((Vec3i)buf.func_179259_c());
        short delay = buf.readShort();
        short maxNearbyEntities = buf.readShort();
        short maxSpawnDelay = buf.readShort();
        short minSpawnDelay = buf.readShort();
        short requiredPlayerRange = buf.readShort();
        short spawnCount = buf.readShort();
        return new SyncSpawnerMessage(pos, delay, spawnCount, requiredPlayerRange, maxNearbyEntities, minSpawnDelay, maxSpawnDelay);
    }

    public static void handle(SyncSpawnerMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            if (world != null) {
                if (!world.func_175667_e(msg.pos)) {
                    return;
                }
                TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(msg.pos);
                MobSpawnerBaseLogic logic = spawner.func_145881_a();
                IBlockState iblockstate = world.func_180495_p(msg.pos);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt = logic.func_189530_b(nbt);
                nbt.func_74777_a("Delay", msg.delay);
                nbt.func_74777_a("SpawnCount", msg.spawnCount);
                nbt.func_74777_a("RequiredPlayerRange", msg.requiredPlayerRange);
                nbt.func_74777_a("MaxNearbyEntities", msg.maxNearbyEntities);
                nbt.func_74777_a("MinSpawnDelay", msg.minSpawnDelay);
                nbt.func_74777_a("MaxSpawnDelay", msg.maxSpawnDelay);
                logic.func_98270_a(nbt);
                spawner.func_70296_d();
                world.func_184138_a(msg.pos, iblockstate, iblockstate, 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

