/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.v14d4n.opentoonline.OpenToOnline;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.ServerHandler;
import com.v14d4n.opentoonline.network.UPnPHandler;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;

public class OpenToOnlineCommand {
    public OpenToOnlineCommand(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"open2online").executes(command -> OpenToOnlineCommand.open()));
    }

    public static int open() {
        int port = (Integer)OpenToOnlineConfig.port.get();
        int maxPlayers = (Integer)OpenToOnlineConfig.maxPlayers.get();
        GameType gameMode = OpenToOnline.minecraft.field_71442_b.func_178889_l();
        boolean allowCheats = OpenToOnline.minecraft.field_71439_g.func_211513_k(4);
        return OpenToOnlineCommand.open(port, maxPlayers, gameMode, allowCheats);
    }

    public static int open(int port, int maxPlayers, GameType gameMode, boolean allowCommands) {
        return OpenToOnlineCommand.open(port, maxPlayers, gameMode, allowCommands, true);
    }

    public static int open(int port, int maxPlayers, GameType gameMode, boolean allowCommands, boolean online) {
        OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.startingServer"));
        if (ServerHandler.isServerPublished()) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.serverIsAlreadyPublished", ModChatTranslatableComponent.MessageTypes.ERROR));
            return 0;
        }
        if (online && !UPnPHandler.isPortAvailable(port)) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.publishFailed", ModChatTranslatableComponent.MessageTypes.ERROR));
            return 0;
        }
        if (!ServerHandler.startServer(port, maxPlayers, gameMode, allowCommands, online)) {
            return 0;
        }
        return 1;
    }
}

