/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.events;

import com.mojang.brigadier.CommandDispatcher;
import com.v14d4n.opentoonline.commands.OpenToOnlineCommand;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.ServerHandler;
import com.v14d4n.opentoonline.network.UPnPHandler;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Session;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="opentoonline")
public class ModEvents {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final Session clientPlayer = minecraft.func_110432_I();

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        new OpenToOnlineCommand((CommandDispatcher<CommandSource>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UPnPHandler.onPlayerLoggedOut(event);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        String loggedInPlayerName = event.getPlayer().func_200200_C_().getString();
        if (clientPlayer.func_111285_a().equals(loggedInPlayerName)) {
            ModEvents.checkUpdates(event.getPlayer());
        }
        if (ServerHandler.isClientRunningOnlineServer() && ServerHandler.isPlayerServerOwner(clientPlayer.func_148256_e()) && ((Boolean)OpenToOnlineConfig.whitelistMode.get()).booleanValue()) {
            ModEvents.kickNotWhitelistedPlayer(event.getPlayer());
        }
    }

    private static void kickNotWhitelistedPlayer(PlayerEntity player) {
        if (clientPlayer.func_111285_a().equals(player.func_200200_C_().getString())) {
            return;
        }
        for (String friendName : (ArrayList)OpenToOnlineConfig.friends.get()) {
            if (!friendName.equals(player.func_200200_C_().getString())) continue;
            return;
        }
        ((ServerPlayerEntity)player).field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("Not in the whitelist"));
    }

    private static void checkUpdates(PlayerEntity player) {
        if (!((Boolean)OpenToOnlineConfig.updateNotifications.get()).booleanValue()) {
            return;
        }
        IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById("opentoonline").get()).getModInfo();
        VersionChecker.CheckResult updateCheckResult = VersionChecker.getResult((IModInfo)modInfo);
        if (updateCheckResult.status.equals((Object)VersionChecker.Status.BETA_OUTDATED)) {
            String currentVersion = modInfo.getVersion().toString().substring(modInfo.getVersion().toString().lastIndexOf(45) + 1);
            String actualVersion = updateCheckResult.target.toString().substring(updateCheckResult.target.toString().lastIndexOf(45) + 1);
            String mainText = new ModChatTranslatableComponent("chat.opentoonline.update", ModChatTranslatableComponent.MessageTypes.WARN).getString() + " \u00a7c" + currentVersion + "\u00a7r -> \u00a7a" + actualVersion + "\u00a7r";
            IFormattableTextComponent link = new TranslationTextComponent("chat.opentoonline.link").func_230530_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, updateCheckResult.url)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("tooltip.opentoonline.openUrl"))));
            IFormattableTextComponent message = new StringTextComponent(mainText).func_240702_b_(" [").func_230529_a_((ITextComponent)link).func_240702_b_("]");
            player.func_145747_a((ITextComponent)message, UUID.randomUUID());
        }
    }
}

