/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network;

import com.mojang.authlib.GameProfile;
import com.v14d4n.opentoonline.OpenToOnline;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.UPnPHandler;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerHandler {
    public static boolean startServer(int port, int maxPlayers, GameType gameMode, boolean allowCommands, boolean online) {
        if (online && !UPnPHandler.openPort(port)) {
            return false;
        }
        if (!OpenToOnline.minecraft.func_71401_C().func_195565_a(gameMode, allowCommands, port)) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.publishFailed", ModChatTranslatableComponent.MessageTypes.ERROR));
            UPnPHandler.closePort(port);
            return false;
        }
        ServerHandler.setupAndSaveServerConfiguration(maxPlayers, port, online);
        ServerHandler.printHostedGameMessage(online, port);
        return true;
    }

    private static void printHostedGameMessage(boolean online, int port) {
        if (online) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.gameHostedOn").func_230529_a_((ITextComponent)ServerHandler.getServerFormattedAddress(port)));
        } else {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.localGameHostedOn").func_230529_a_((ITextComponent)ServerHandler.getServerFormattedPort(port)));
        }
    }

    private static void setupAndSaveServerConfiguration(int maxPlayers, int port, boolean closePortAfterLogout) {
        ServerHandler.setPvpAllowed((Boolean)OpenToOnlineConfig.allowPvp.get());
        if (ServerHandler.setMaxPlayers(maxPlayers)) {
            OpenToOnlineConfig.maxPlayers.set((Object)maxPlayers);
        }
        OpenToOnlineConfig.port.set((Object)port);
        UPnPHandler.closePortAfterLogout(closePortAfterLogout);
    }

    public static boolean isServerPublished() {
        return !OpenToOnline.minecraft.func_71356_B() || OpenToOnline.minecraft.func_71401_C().func_71344_c();
    }

    private static void setLicenseGameRequired(boolean requireLicense) {
        OpenToOnline.minecraft.func_71401_C().func_71229_d(requireLicense);
    }

    private static void setPvpAllowed(boolean allowPvp) {
        OpenToOnline.minecraft.func_71401_C().func_71188_g(allowPvp);
    }

    private static boolean setMaxPlayers(int maxPlayers) {
        PlayerList playerList = OpenToOnline.minecraft.func_71401_C().func_184103_al();
        try {
            Field field = PlayerList.class.getDeclaredField("field_72405_c");
            field.setAccessible(true);
            field.setInt(playerList, maxPlayers);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.warn.settingMaxPlayers", ModChatTranslatableComponent.MessageTypes.WARN));
            return false;
        }
        return true;
    }

    private static String getExternalIP() {
        try {
            String currentIP = new BufferedReader(new InputStreamReader(new URL("https://checkip.amazonaws.com").openStream())).readLine();
            String lastIP = (String)OpenToOnlineConfig.lastIP.get();
            if (!currentIP.equals(lastIP) && !lastIP.equals("0.0.0.0")) {
                OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.ipIsChanged", ModChatTranslatableComponent.MessageTypes.WARN));
            }
            OpenToOnlineConfig.lastIP.set((Object)currentIP);
            return currentIP;
        }
        catch (IOException e) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.warn.gettingAnExternalIP", ModChatTranslatableComponent.MessageTypes.WARN));
            return "0.0.0.0";
        }
    }

    private static IFormattableTextComponent getServerFormattedPort(int port) {
        String stringPort = String.valueOf(port);
        IFormattableTextComponent formattablePort = new StringTextComponent(stringPort).func_230530_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stringPort)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("tooltip.opentoonline.copy"))));
        return new StringTextComponent(" [").func_230529_a_((ITextComponent)formattablePort).func_240702_b_("]");
    }

    private static IFormattableTextComponent getServerFormattedAddress(int port) {
        String stringAddress = ServerHandler.getExternalIP() + ":" + port;
        IFormattableTextComponent serverAddress = new StringTextComponent(stringAddress).func_230530_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stringAddress)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("tooltip.opentoonline.copy"))));
        return new StringTextComponent(" [").func_230529_a_((ITextComponent)serverAddress).func_240702_b_("]");
    }

    public static boolean isPlayerServerOwner(GameProfile gameProfile) {
        return OpenToOnline.minecraft.func_71401_C().func_213199_b(gameProfile);
    }

    public static boolean isClientRunningOnlineServer() {
        return UPnPHandler.getClosePortAfterLogout();
    }
}

