/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network;

import com.v14d4n.opentoonline.OpenToOnline;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import com.v14d4n.opentoonline.network.nat.IUPnPLibrary;
import com.v14d4n.opentoonline.network.nat.UPnPLibraries;
import java.io.IOException;
import java.net.Socket;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class UPnPHandler {
    private static boolean closePortAfterLogout;
    private static IUPnPLibrary UPnP;

    private static boolean isUPnPAvailable() {
        UPnP = UPnPLibraries.getById((Integer)OpenToOnlineConfig.libraryId.get()).getHandler();
        if ((Integer)OpenToOnlineConfig.libraryId.get() != 2) {
            if (UPnP.isUPnPAvailable()) {
                OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.upnpIsAvailable"));
                return true;
            }
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.upnpIsNotAvailable", ModChatTranslatableComponent.MessageTypes.ERROR));
        } else {
            if (UPnP.isUPnPAvailable()) {
                OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.upnpNatPcpIsAvailable"));
                return true;
            }
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.upnpNatPcpIsNotAvailable", ModChatTranslatableComponent.MessageTypes.ERROR));
        }
        return false;
    }

    public static boolean openPort(int port) {
        if (!UPnPHandler.isUPnPAvailable()) {
            return false;
        }
        OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.openingTcpPort").func_240702_b_(" " + port + "..."));
        if (UPnP.isMappedTCP(port)) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.portIsAlreadyOpen"));
        } else if (UPnP.openPortTCP(port)) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.portIsOpen"));
        } else {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.portOpening", ModChatTranslatableComponent.MessageTypes.ERROR));
            return false;
        }
        return true;
    }

    public static boolean closePort(int port) {
        if (UPnP == null) {
            throw new RuntimeException("UPnP library is not installed");
        }
        OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.closingTcpPort").func_240702_b_(" " + port + "..."));
        if (!UPnP.isMappedTCP(port)) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.portIsAlreadyClosed"));
        } else if (UPnP.closePortTCP(port)) {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.portIsClosed"));
        } else {
            OpenToOnline.minecraft.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new ModChatTranslatableComponent("chat.opentoonline.error.portClosing", ModChatTranslatableComponent.MessageTypes.ERROR));
            return false;
        }
        return true;
    }

    public static void closePortAfterLogout(boolean closePortAfterLogout) {
        UPnPHandler.closePortAfterLogout = closePortAfterLogout;
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String loggedOutPlayerName;
        String clientPlayerName = OpenToOnline.minecraft.func_110432_I().func_111285_a();
        if (clientPlayerName.equals(loggedOutPlayerName = event.getPlayer().func_200200_C_().getString()) && closePortAfterLogout) {
            UPnPHandler.closePortAfterLogout(false);
            int port = (Integer)OpenToOnlineConfig.port.get();
            if (UPnP.isMappedTCP(port)) {
                UPnP.closePortTCP(port);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (Socket ignored = new Socket("localhost", port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored2) {
            return true;
        }
    }

    public static boolean getClosePortAfterLogout() {
        return closePortAfterLogout;
    }
}

