/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network.nat;

import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.nat.IUPnPLibrary;
import com.v14d4n.opentoonline.relocated.portmapper.PortMapperFactory;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Gateway;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.NetworkGateway;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.KillNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ProcessGateway;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.KillProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import java.net.InetAddress;
import java.util.List;

public class PortMapperLibrary
implements IUPnPLibrary {
    private final Gateway network = NetworkGateway.create();
    private final Gateway process = ProcessGateway.create();
    private final Bus networkBus = this.network.getBus();
    private final Bus processBus = this.process.getBus();
    private List<PortMapper> mappers;
    private PortMapper currentMapper;
    private MappedPort mappedPort;
    private final Thread updateLifetimeThread = new Thread(this::updateLifetime);
    private final long lifetime = 20L;
    private boolean isMapped;

    public PortMapperLibrary() {
        this.updateLifetimeThread.setDaemon(true);
    }

    @Override
    public boolean isUPnPAvailable() {
        try {
            this.mappers = PortMapperFactory.discover(this.networkBus, this.processBus, new InetAddress[0]);
        }
        catch (Exception e) {
            return false;
        }
        return this.mappers.size() > 0;
    }

    @Override
    public boolean isMappedTCP(int port) {
        return this.isMapped;
    }

    @Override
    public boolean openPortTCP(int port) {
        int portMapperIndex = (Integer)OpenToOnlineConfig.portMapperIndex.get();
        if (portMapperIndex != -1) {
            try {
                this.mappedPort = this.mappers.get(portMapperIndex).mapPort(PortType.TCP, port, port, 1L);
                this.currentMapper = this.mappers.get(portMapperIndex);
                this.updateLifetimeThread.start();
                this.isMapped = true;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.mappers.size(); ++i) {
            if (i == portMapperIndex) continue;
            try {
                this.mappedPort = this.mappers.get(i).mapPort(PortType.TCP, port, port, 1L);
                this.currentMapper = this.mappers.get(i);
            }
            catch (Exception e) {
                continue;
            }
            this.updateLifetimeThread.start();
            this.isMapped = true;
            OpenToOnlineConfig.portMapperIndex.set((Object)i);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closePortTCP(int port) {
        boolean isPortClosed = true;
        this.updateLifetimeThread.interrupt();
        try {
            this.currentMapper.unmapPort(this.mappedPort);
        }
        catch (Exception e) {
            isPortClosed = false;
        }
        finally {
            this.networkBus.send(new KillNetworkRequest());
            this.processBus.send(new KillProcessRequest());
        }
        return isPortClosed;
    }

    private void updateLifetime() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                this.mappedPort = this.currentMapper.refreshPort(this.mappedPort, 20000L);
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

