/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network.nat;

import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.nat.IUPnPLibrary;
import com.v14d4n.opentoonline.network.nat.PortMapperLibrary;
import com.v14d4n.opentoonline.network.nat.WaifUPnPLibrary;
import com.v14d4n.opentoonline.network.nat.WeUPnPLibrary;
import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum UPnPLibraries {
    WeUPnP(0, WeUPnPLibrary::new),
    WaifUPnP(1, WaifUPnPLibrary::new),
    PortMapper(2, PortMapperLibrary::new);

    private final int id;
    private final Supplier<IUPnPLibrary> librarySupplier;

    private UPnPLibraries(int id, Supplier<IUPnPLibrary> librarySupplier) {
        this.id = id;
        this.librarySupplier = librarySupplier;
    }

    public int getId() {
        return this.id;
    }

    public IUPnPLibrary getHandler() {
        return this.librarySupplier.get();
    }

    public ITextComponent getTextComponent() {
        return new StringTextComponent(this.name());
    }

    public static UPnPLibraries getById(int id) {
        for (UPnPLibraries library : UPnPLibraries.values()) {
            if (library.getId() != id) continue;
            return library;
        }
        OpenToOnlineConfig.libraryId.set((Object)0);
        return UPnPLibraries.getById(0);
    }
}

