/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.NatPmpPortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.PcpPortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.UpnpIgdPortMapper;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortMapperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PortMapperFactory.class);

    private PortMapperFactory() {
    }

    public static List<PortMapper> discover(Bus networkBus, Bus processBus, InetAddress ... additionalIps) throws InterruptedException {
        Validate.notNull(networkBus);
        Validate.notNull(processBus);
        Validate.notNull(additionalIps);
        Validate.noNullElements(additionalIps);
        LinkedList<PortMapper> ret = new LinkedList<PortMapper>();
        List<UpnpIgdPortMapper> upnpIgdMappers = UpnpIgdPortMapper.identify(networkBus);
        LOG.debug("Found UPnP-IGD mappers: {}", (Object)upnpIgdMappers);
        List<NatPmpPortMapper> natPmpMappers = NatPmpPortMapper.identify(networkBus, processBus, additionalIps);
        LOG.debug("Found NAT-PMP mappers: {}", (Object)natPmpMappers);
        List<PcpPortMapper> pcpMappers = PcpPortMapper.identify(networkBus, processBus, additionalIps);
        LOG.debug("Found PCP mappers: {}", (Object)pcpMappers);
        ret.addAll(upnpIgdMappers);
        ret.addAll(natPmpMappers);
        ret.addAll(pcpMappers);
        LOG.debug("Total found mappers: {}", (Object)ret);
        return ret;
    }
}

