/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.gateways.network;

import com.v14d4n.opentoonline.relocated.commons.io.IOUtils;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.NetworkBus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.NetworkEntry;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.TcpNetworkEntry;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.UdpNetworkEntry;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CloseNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CloseNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ConnectedTcpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CreateTcpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CreateTcpNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CreateUdpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CreateUdpNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ErrorNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetLocalIpAddressesNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetLocalIpAddressesNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetNextIdNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetNextIdNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.IdentifiableErrorNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.IdentifiableErrorNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.KillNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ReadClosedTcpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ReadTcpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ReadUdpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteEmptyTcpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteEmptyUdpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteTcpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteTcpNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteUdpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteUdpNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.ByteBufferUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NetworkRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkRunnable.class);
    private final Bus bus;
    private final LinkedBlockingQueue<Object> queue;
    private final Selector selector;
    private int nextId = 0;
    private Map<Integer, NetworkEntry<?>> idMap = new HashMap();
    private Map<Channel, NetworkEntry<?>> channelMap = new HashMap();
    private ByteBuffer buffer = ByteBuffer.allocate(65535);

    NetworkRunnable() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        this.queue = new LinkedBlockingQueue();
        this.bus = new NetworkBus(this.selector, this.queue);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Override
    public void run() {
        LOG.debug("Starting gateway");
        try {
            block8: while (true) {
                this.selector.select();
                for (SelectionKey key : this.selector.selectedKeys()) {
                    if (!key.isValid()) continue;
                    SelectableChannel channel = key.channel();
                    NetworkEntry<?> entry = this.channelMap.get(channel);
                    if (entry == null) {
                        channel.close();
                        continue;
                    }
                    try {
                        if (channel instanceof SocketChannel) {
                            this.handleSelectForTcpChannel(key, (TcpNetworkEntry)entry);
                        } else if (channel instanceof DatagramChannel) {
                            this.handleSelectForUdpChannel(key, (UdpNetworkEntry)entry);
                        } else {
                            throw new IllegalStateException();
                        }
                        this.updateSelectionKey(entry, (AbstractSelectableChannel)channel);
                    }
                    catch (RuntimeException e) {
                        int id = entry.getId();
                        LOG.error(id + " Exception encountered", e);
                        entry.getResponseBus().send(new IdentifiableErrorNetworkNotification(id));
                    }
                }
                LinkedList msgs = new LinkedList();
                this.queue.drainTo(msgs);
                Iterator iterator = msgs.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block8;
                    Object msg = iterator.next();
                    this.processMessage(msg);
                }
                break;
            }
        }
        catch (KillRequestException kre) {
            LOG.debug("Stopping gateway");
            this.shutdownResources();
            LOG.debug("Shutdown of resources complete");
        }
        catch (Exception e) {
            try {
                LOG.error("Encountered unexpected exception", e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                LOG.debug("Stopping gateway");
                this.shutdownResources();
                LOG.debug("Shutdown of resources complete");
                throw throwable;
            }
        }
    }

    private void handleSelectForTcpChannel(SelectionKey selectionKey, TcpNetworkEntry entry) {
        block16: {
            SocketChannel channel = (SocketChannel)entry.getChannel();
            Bus responseBus = entry.getResponseBus();
            int id = entry.getId();
            if (selectionKey.isConnectable()) {
                LOG.debug("{} TCP connection", (Object)id);
                try {
                    boolean alreadyConnected = channel.isConnected();
                    boolean connected = channel.finishConnect();
                    if (!alreadyConnected && connected) {
                        entry.setConnecting(false);
                        responseBus.send(new ConnectedTcpNetworkNotification(id));
                    }
                }
                catch (IOException ioe) {
                    LOG.debug(id + " Exception encountered", ioe);
                    responseBus.send(new IdentifiableErrorNetworkNotification(id));
                }
            }
            if (selectionKey.isReadable()) {
                try {
                    this.buffer.clear();
                    int readCount = channel.read(this.buffer);
                    this.buffer.flip();
                    LOG.debug("{} TCP read {} bytes", (Object)id, (Object)readCount);
                    if (readCount == -1) {
                        entry.setReadFinished(true);
                        responseBus.send(new ReadClosedTcpNetworkNotification(id));
                    } else if (this.buffer.remaining() > 0) {
                        byte[] bufferAsArray = ByteBufferUtils.copyContentsToArray(this.buffer);
                        responseBus.send(new ReadTcpNetworkNotification(id, bufferAsArray));
                    }
                }
                catch (IOException ioe) {
                    LOG.debug(id + " Exception encountered", ioe);
                    responseBus.send(new IdentifiableErrorNetworkNotification(id));
                }
            }
            if (selectionKey.isWritable()) {
                try {
                    LinkedList<ByteBuffer> outBuffers = entry.getOutgoingBuffers();
                    int writeCount = 0;
                    if (outBuffers.isEmpty() && !entry.isNotifiedOfWritable()) {
                        LOG.debug("{} TCP write empty", (Object)id);
                        entry.setNotifiedOfWritable(true);
                        entry.getResponseBus().send(new WriteEmptyTcpNetworkNotification(id));
                        break block16;
                    }
                    while (!outBuffers.isEmpty()) {
                        ByteBuffer outBuffer = outBuffers.getFirst();
                        LOG.debug("{} TCP wrote {} bytes", (Object)id, (Object)(writeCount += channel.write(outBuffer)));
                        if (outBuffer.remaining() <= 0) {
                            outBuffers.removeFirst();
                            responseBus.send(new WriteTcpNetworkResponse(id, writeCount));
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    LOG.debug(id + " Exception encountered", ioe);
                    responseBus.send(new IdentifiableErrorNetworkNotification(id));
                }
            }
        }
    }

    private void handleSelectForUdpChannel(SelectionKey selectionKey, UdpNetworkEntry entry) {
        DatagramChannel channel = (DatagramChannel)entry.getChannel();
        Bus responseBus = entry.getResponseBus();
        int id = entry.getId();
        if (selectionKey.isReadable()) {
            try {
                this.buffer.clear();
                InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
                InetSocketAddress remoteAddress = (InetSocketAddress)channel.receive(this.buffer);
                LOG.debug("{} UDP read {} bytes from {} to {}", id, this.buffer.position(), remoteAddress, localAddress);
                if (remoteAddress != null) {
                    this.buffer.flip();
                    byte[] bufferAsArray = ByteBufferUtils.copyContentsToArray(this.buffer);
                    responseBus.send(new ReadUdpNetworkNotification(id, localAddress, remoteAddress, bufferAsArray));
                }
            }
            catch (IOException ioe) {
                LOG.debug(id + " Exception encountered", ioe);
                responseBus.send(new IdentifiableErrorNetworkNotification(id));
            }
        }
        if (selectionKey.isWritable()) {
            try {
                LinkedList<UdpNetworkEntry.AddressedByteBuffer> outBuffers = entry.getOutgoingBuffers();
                if (!outBuffers.isEmpty()) {
                    UdpNetworkEntry.AddressedByteBuffer outBuffer = outBuffers.removeFirst();
                    ByteBuffer outgoingBuffer = outBuffer.getBuffer();
                    InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
                    InetSocketAddress remoteAddress = outBuffer.getSocketAddress();
                    int totalCount = outgoingBuffer.remaining();
                    int writeCount = channel.send(outgoingBuffer, remoteAddress);
                    LOG.debug("{} UDP wrote {} bytes of {} from {} to {}", id, writeCount, totalCount, localAddress, remoteAddress);
                    responseBus.send(new WriteUdpNetworkResponse(id, writeCount));
                } else if (!entry.isNotifiedOfWritable()) {
                    LOG.debug("{} UDP write empty", (Object)id);
                    entry.setNotifiedOfWritable(true);
                    entry.getResponseBus().send(new WriteEmptyUdpNetworkNotification(id));
                }
            }
            catch (IOException ioe) {
                LOG.debug(id + " Exception encountered", ioe);
                responseBus.send(new IdentifiableErrorNetworkNotification(id));
            }
        }
    }

    private void updateSelectionKey(NetworkEntry<?> entry, AbstractSelectableChannel channel) throws ClosedChannelException {
        int newKey = 0;
        if (entry instanceof TcpNetworkEntry) {
            TcpNetworkEntry tcpNetworkEntry = (TcpNetworkEntry)entry;
            if (tcpNetworkEntry.isConnecting()) {
                newKey |= 8;
            }
            if (!tcpNetworkEntry.isReadFinished()) {
                newKey |= 1;
            }
        } else if (entry instanceof UdpNetworkEntry) {
            newKey |= 1;
        }
        if (!entry.getOutgoingBuffers().isEmpty()) {
            newKey |= 4;
            entry.setNotifiedOfWritable(false);
        } else if (!entry.isNotifiedOfWritable()) {
            newKey |= 4;
        }
        if (newKey != entry.getSelectionKey()) {
            entry.setSelectionKey(newKey);
            int id = entry.getId();
            LOG.debug("{} Key updated to {}", (Object)id, (Object)newKey);
            channel.register(this.selector, newKey);
        }
    }

    private void processMessage(Object msg) throws IOException {
        block39: {
            LOG.debug("Processing message: {}", msg);
            if (msg instanceof GetNextIdNetworkRequest) {
                int id = this.nextId++;
                GetNextIdNetworkRequest req = (GetNextIdNetworkRequest)msg;
                Bus responseBus = req.getResponseBus();
                responseBus.send(new GetNextIdNetworkResponse(id));
            } else if (msg instanceof CreateUdpNetworkRequest) {
                CreateUdpNetworkRequest req = (CreateUdpNetworkRequest)msg;
                int id = req.getId();
                Bus responseBus = req.getResponseBus();
                DatagramChannel channel = null;
                NetworkEntry entry = null;
                try {
                    channel = DatagramChannel.open();
                    channel.configureBlocking(false);
                    channel.socket().bind(new InetSocketAddress(req.getSourceAddress(), 0));
                    entry = new UdpNetworkEntry(id, channel, responseBus);
                    this.updateSelectionKey(entry, channel);
                    this.idMap.put(id, entry);
                    this.channelMap.put(channel, entry);
                    responseBus.send(new CreateUdpNetworkResponse(id));
                }
                catch (RuntimeException re) {
                    if (channel != null) {
                        IOUtils.closeQuietly((Closeable)channel);
                    }
                    if (entry != null) {
                        this.idMap.remove(entry.getId());
                        this.channelMap.remove(entry.getChannel());
                    }
                    LOG.debug("Unable to create socket", re);
                    responseBus.send(new IdentifiableErrorNetworkResponse(id));
                }
            } else if (msg instanceof CreateTcpNetworkRequest) {
                CreateTcpNetworkRequest req = (CreateTcpNetworkRequest)msg;
                int id = req.getId();
                Bus responseBus = req.getResponseBus();
                SocketChannel channel = null;
                NetworkEntry entry = null;
                try {
                    channel = SocketChannel.open();
                    channel.configureBlocking(false);
                    channel.socket().bind(new InetSocketAddress(req.getSourceAddress(), 0));
                    InetSocketAddress dst = new InetSocketAddress(req.getDestinationAddress(), req.getDestinationPort());
                    channel.connect(dst);
                    entry = new TcpNetworkEntry(id, channel, responseBus);
                    ((TcpNetworkEntry)entry).setConnecting(true);
                    this.updateSelectionKey(entry, channel);
                    this.idMap.put(id, entry);
                    this.channelMap.put(channel, entry);
                    responseBus.send(new CreateTcpNetworkResponse(id));
                }
                catch (RuntimeException re) {
                    if (channel != null) {
                        IOUtils.closeQuietly((Closeable)channel);
                    }
                    if (entry != null) {
                        this.idMap.remove(entry.getId());
                        this.channelMap.remove(entry.getChannel());
                    }
                    LOG.debug("Unable to create socket", re);
                    responseBus.send(new IdentifiableErrorNetworkResponse(id));
                }
            } else if (msg instanceof CloseNetworkRequest) {
                CloseNetworkRequest req = (CloseNetworkRequest)msg;
                int id = req.getId();
                NetworkEntry<?> entry = this.idMap.get(id);
                if (entry != null) {
                    Bus responseBus = entry.getResponseBus();
                    Channel channel = entry.getChannel();
                    this.idMap.remove(id);
                    this.channelMap.remove(channel);
                    IOUtils.closeQuietly((Closeable)channel);
                    responseBus.send(new CloseNetworkResponse(id));
                }
            } else {
                if (msg instanceof WriteTcpNetworkRequest) {
                    WriteTcpNetworkRequest req = (WriteTcpNetworkRequest)msg;
                    Bus responseBus = null;
                    int id = req.getId();
                    try {
                        TcpNetworkEntry entry = (TcpNetworkEntry)this.idMap.get(id);
                        if (entry != null) {
                            responseBus = entry.getResponseBus();
                            LinkedList<ByteBuffer> outBuffers = entry.getOutgoingBuffers();
                            ByteBuffer writeBuffer = ByteBuffer.wrap(req.getData());
                            if (writeBuffer.hasRemaining()) {
                                outBuffers.add(writeBuffer);
                            }
                            AbstractSelectableChannel channel = (AbstractSelectableChannel)entry.getChannel();
                            this.updateSelectionKey(entry, channel);
                        }
                        break block39;
                    }
                    catch (RuntimeException re) {
                        LOG.debug("Unable to process message", re);
                        if (responseBus != null) {
                            responseBus.send(new IdentifiableErrorNetworkResponse(id));
                        }
                        break block39;
                    }
                }
                if (msg instanceof WriteUdpNetworkRequest) {
                    WriteUdpNetworkRequest req = (WriteUdpNetworkRequest)msg;
                    Bus responseBus = null;
                    int id = req.getId();
                    try {
                        UdpNetworkEntry entry = (UdpNetworkEntry)this.idMap.get(id);
                        if (entry != null) {
                            responseBus = entry.getResponseBus();
                            LinkedList<UdpNetworkEntry.AddressedByteBuffer> outBuffers = entry.getOutgoingBuffers();
                            ByteBuffer writeBuffer = ByteBuffer.wrap(req.getData());
                            InetSocketAddress writeAddress = req.getRemoteAddress();
                            outBuffers.add(new UdpNetworkEntry.AddressedByteBuffer(writeBuffer, writeAddress));
                            AbstractSelectableChannel channel = (AbstractSelectableChannel)entry.getChannel();
                            this.updateSelectionKey(entry, channel);
                        }
                        break block39;
                    }
                    catch (RuntimeException re) {
                        LOG.debug("Unable to process message", re);
                        if (responseBus != null) {
                            responseBus.send(new IdentifiableErrorNetworkResponse(id));
                        }
                        break block39;
                    }
                }
                if (msg instanceof GetLocalIpAddressesNetworkRequest) {
                    GetLocalIpAddressesNetworkRequest req = (GetLocalIpAddressesNetworkRequest)msg;
                    HashSet<InetAddress> ret = new HashSet<InetAddress>();
                    Bus responseBus = req.getResponseBus();
                    try {
                        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                        while (interfaces.hasMoreElements()) {
                            NetworkInterface networkInterface = interfaces.nextElement();
                            if (!networkInterface.isUp()) {
                                LOG.debug("Interface {} not up -- skipping", (Object)networkInterface);
                                continue;
                            }
                            try {
                                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                                while (addrs.hasMoreElements()) {
                                    InetAddress addr = addrs.nextElement();
                                    if (addr.isLoopbackAddress()) continue;
                                    ret.add(addr);
                                }
                            }
                            catch (RuntimeException niException) {
                                LOG.warn("Unable to access interface {}", (Object)networkInterface, (Object)niException);
                            }
                        }
                        responseBus.send(new GetLocalIpAddressesNetworkResponse(ret));
                    }
                    catch (RuntimeException re) {
                        LOG.debug("Unable to process message", re);
                        if (responseBus != null) {
                            responseBus.send(new ErrorNetworkResponse());
                        }
                    }
                } else if (msg instanceof KillNetworkRequest) {
                    throw new KillRequestException();
                }
            }
        }
    }

    private void shutdownResources() {
        LOG.debug("Shutting down all resources");
        for (int id : new HashSet<Integer>(this.idMap.keySet())) {
            this.forcefullyShutdownResource(id);
        }
        try {
            this.selector.close();
        }
        catch (Exception e) {
            LOG.error("Error shutting down selector", e);
        }
        this.channelMap.clear();
        this.idMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcefullyShutdownResource(int id) {
        NetworkEntry<?> ne = this.idMap.remove(id);
        LOG.debug("{} Attempting to shutdown", (Object)id);
        Channel channel = null;
        try {
            channel = ne.getChannel();
            this.channelMap.remove(channel);
            ne.getResponseBus().send(new IdentifiableErrorNetworkNotification(id));
        }
        catch (RuntimeException e) {
            LOG.error(id + " Error shutting down resource", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)channel);
        }
    }

    private static final class KillRequestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private KillRequestException() {
        }
    }
}

