/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.IdentifiableNetworkRequest;
import java.net.InetAddress;

public final class CreateTcpNetworkRequest
extends IdentifiableNetworkRequest {
    private Bus responseBus;
    private InetAddress sourceAddress;
    private InetAddress destinationAddress;
    private int destinationPort;

    public CreateTcpNetworkRequest(int id, Bus responseBus, InetAddress sourceAddress, InetAddress destinationAddress, int destinationPort) {
        super(id);
        Validate.notNull(responseBus);
        Validate.notNull(sourceAddress);
        Validate.notNull(destinationAddress);
        Validate.inclusiveBetween(1L, 65535L, destinationPort);
        this.responseBus = responseBus;
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.destinationPort = destinationPort;
    }

    public Bus getResponseBus() {
        return this.responseBus;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public InetAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    @Override
    public String toString() {
        return "CreateTcpNetworkRequest{responseBus=" + this.responseBus + ", sourceAddress=" + this.sourceAddress + ", destinationAddress=" + this.destinationAddress + ", destinationPort=" + this.destinationPort + '}';
    }
}

