/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.gateways.process;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.TerminatedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProcessMonitorRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessMonitorRunnable.class);
    private final int id;
    private final Process process;
    private final Bus processBus;
    private final Thread stdoutThread;
    private final Thread stderrThread;

    ProcessMonitorRunnable(int id, Process process, Bus processBus, Thread stdoutThread, Thread stderrThread) {
        Validate.notNull(process);
        Validate.notNull(processBus);
        Validate.notNull(stdoutThread);
        Validate.notNull(stderrThread);
        this.id = id;
        this.process = process;
        this.processBus = processBus;
        this.stdoutThread = stdoutThread;
        this.stderrThread = stderrThread;
    }

    @Override
    public void run() {
        LOG.debug("{} Starting up monitor", (Object)this.id);
        try {
            int exitCode = this.process.waitFor();
            LOG.debug("{} Process closed with exit code {}", (Object)this.id, (Object)exitCode);
            this.stdoutThread.join();
            this.stderrThread.join();
        }
        catch (RuntimeException e) {
            LOG.error(this.id + " Encountered exception", e);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            LOG.debug(this.id + " Interrupted", ie);
        }
        finally {
            try {
                this.process.destroy();
            }
            catch (RuntimeException re) {}
            try {
                this.processBus.send(new TerminatedMessage(this.id, null));
            }
            catch (RuntimeException re) {}
            LOG.debug("{} Shutting down monitor", (Object)this.id);
        }
    }
}

