/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.gateways.process;

import com.v14d4n.opentoonline.relocated.commons.io.IOUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ReadMessage;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ReadType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProcessReaderRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessReaderRunnable.class);
    private int id;
    private final InputStream inputStream;
    private final Bus processBus;
    private final ReadType readType;

    ProcessReaderRunnable(int id, InputStream inputStream, Bus processBus, ReadType readType) {
        Validate.notNull(inputStream);
        Validate.notNull(processBus);
        Validate.notNull(readType);
        this.id = id;
        this.inputStream = inputStream;
        this.processBus = processBus;
        this.readType = readType;
    }

    @Override
    public void run() {
        LOG.debug("{} Starting up reader {}", (Object)this.id, (Object)this.readType);
        byte[] buffer = new byte[8192];
        try {
            while (true) {
                int count;
                if ((count = this.inputStream.read(buffer)) == -1) {
                    LOG.debug("{} {} ended", (Object)this.id, (Object)this.readType);
                    break;
                }
                LOG.debug("{} Read {} bytes from {}", new Object[]{this.id, count, this.readType});
                this.processBus.send(new ReadMessage(this.id, Arrays.copyOf(buffer, count), this.readType));
            }
        }
        catch (IOException | RuntimeException ioe) {
            LOG.error(this.id + " " + (Object)((Object)this.readType) + " encountered exception", ioe);
        }
        finally {
            IOUtils.closeQuietly(this.inputStream);
            LOG.debug("{} Shutting down reader {}", (Object)this.id, (Object)this.readType);
        }
    }
}

