/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.gateways.process;

import com.v14d4n.opentoonline.relocated.commons.collections4.list.UnmodifiableList;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.BasicBus;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ProcessEntry;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ProcessMonitorRunnable;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ProcessReaderRunnable;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ProcessWriterRunnable;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.ReadMessage;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.TerminatedMessage;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.WriteEmptyMessage;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.CloseProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.CreateProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.CreateProcessResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ExitProcessNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.GetNextIdProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.GetNextIdProcessResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.IdentifiableErrorProcessResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.KillProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ReadProcessNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ReadType;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.WriteEmptyProcessNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.WriteProcessRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProcessRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessRunnable.class);
    private final Bus bus;
    private final LinkedBlockingQueue<Object> queue;
    private int nextId = 0;
    private Map<Integer, ProcessEntry> idMap = new HashMap<Integer, ProcessEntry>();

    ProcessRunnable() {
        this.queue = new LinkedBlockingQueue();
        this.bus = new BasicBus(this.queue);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Override
    public void run() {
        LOG.debug("Starting gateway");
        try {
            while (true) {
                Object msg = this.queue.take();
                this.processMessage(msg);
            }
        }
        catch (KillRequestException kre) {
            LOG.debug("Stopping gateway");
            this.shutdownResources();
            LOG.debug("Shutdown of resources complete");
        }
        catch (Exception e) {
            try {
                LOG.error("Encountered unexpected exception", e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                LOG.debug("Stopping gateway");
                this.shutdownResources();
                LOG.debug("Shutdown of resources complete");
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(Object msg) {
        LOG.debug("Processing message: {}", msg);
        if (msg instanceof GetNextIdProcessRequest) {
            int id = this.nextId++;
            GetNextIdProcessRequest req = (GetNextIdProcessRequest)msg;
            Bus responseBus = req.getResponseBus();
            responseBus.send(new GetNextIdProcessResponse(id));
        } else if (msg instanceof CreateProcessRequest) {
            CreateProcessRequest req = (CreateProcessRequest)msg;
            int id = req.getId();
            Bus responseBus = req.getResponseBus();
            Process process = null;
            Thread monitorThread = null;
            Thread stdoutThread = null;
            Thread stderrThread = null;
            Thread stdinThread = null;
            try {
                String executable = req.getExecutable();
                UnmodifiableList<String> parameters = req.getParameters();
                LinkedList<String> command = new LinkedList<String>();
                command.add(executable);
                command.addAll(parameters);
                ProcessBuilder pb = new ProcessBuilder(command);
                process = pb.start();
                ProcessReaderRunnable stdoutRunnable = new ProcessReaderRunnable(id, process.getInputStream(), this.bus, ReadType.STDOUT);
                stdoutThread = new Thread(stdoutRunnable);
                stdoutThread.setDaemon(true);
                stdoutThread.setName("Stdout Monitor");
                ProcessReaderRunnable stderrRunnable = new ProcessReaderRunnable(id, process.getErrorStream(), this.bus, ReadType.STDERR);
                stderrThread = new Thread(stderrRunnable);
                stderrThread.setDaemon(true);
                stderrThread.setName("Stderr Monitor");
                ProcessWriterRunnable stdinRunnable = new ProcessWriterRunnable(id, process.getOutputStream(), this.bus);
                stdinThread = new Thread(stdinRunnable);
                stdinThread.setDaemon(true);
                stdinThread.setName("Stdin Monitor");
                ProcessMonitorRunnable monitorRunnable = new ProcessMonitorRunnable(id, process, this.bus, stdoutThread, stderrThread);
                monitorThread = new Thread(monitorRunnable);
                monitorThread.setDaemon(true);
                monitorThread.setName("Process Monitor");
                ProcessEntry entry = new ProcessEntry(process, monitorThread, stdinThread, stdoutThread, stderrThread, stdinRunnable.getLocalInputBus(), id, responseBus);
                responseBus.send(new CreateProcessResponse(id));
                this.idMap.put(id, entry);
                stdoutThread.start();
                stderrThread.start();
                stdinThread.start();
                monitorThread.start();
            }
            catch (IOException | RuntimeException re) {
                this.idMap.remove(id);
                LOG.error("Unable to create process", re);
                if (stdoutThread != null) {
                    stdoutThread.interrupt();
                }
                if (stderrThread != null) {
                    stderrThread.interrupt();
                }
                if (stdinThread != null) {
                    stdinThread.interrupt();
                }
                if (monitorThread != null) {
                    monitorThread.interrupt();
                }
                if (process != null) {
                    process.destroy();
                }
                responseBus.send(new IdentifiableErrorProcessResponse(id));
            }
        } else if (msg instanceof CloseProcessRequest) {
            CloseProcessRequest req = (CloseProcessRequest)msg;
            int id = req.getId();
            ProcessEntry entry = this.idMap.get(id);
            if (entry != null) {
                entry.getProcess().destroy();
            }
        } else if (msg instanceof TerminatedMessage) {
            TerminatedMessage req = (TerminatedMessage)msg;
            Integer exitCode = req.getExitCode();
            int id = req.getId();
            ProcessEntry entry = this.idMap.remove(id);
            if (entry != null) {
                try {
                    entry.getProcess().destroy();
                    entry.getStdoutThread().interrupt();
                    entry.getStderrThread().interrupt();
                    entry.getStdinThread().interrupt();
                    entry.getExitThread().interrupt();
                }
                catch (RuntimeException re) {
                    LOG.error("Unable to process terminate message", re);
                }
                finally {
                    Bus responseBus = entry.getResponseBus();
                    responseBus.send(new ExitProcessNotification(id, exitCode));
                }
            }
        } else if (msg instanceof WriteEmptyMessage) {
            WriteEmptyMessage req = (WriteEmptyMessage)msg;
            int id = req.getId();
            ProcessEntry entry = this.idMap.get(id);
            if (entry != null) {
                Bus responseBus = entry.getResponseBus();
                responseBus.send(new WriteEmptyProcessNotification(id));
            }
        } else if (msg instanceof ReadMessage) {
            ReadMessage req = (ReadMessage)msg;
            int id = req.getId();
            ProcessEntry entry = this.idMap.get(id);
            if (entry != null) {
                Bus responseBus = entry.getResponseBus();
                responseBus.send(new ReadProcessNotification(id, req.getData(), req.getReadType()));
            }
        } else if (msg instanceof WriteProcessRequest) {
            WriteProcessRequest req = (WriteProcessRequest)msg;
            int id = req.getId();
            ProcessEntry entry = this.idMap.get(id);
            if (entry != null) {
                entry.getStdinBus().send(ByteBuffer.wrap(req.getData()));
            }
        } else if (msg instanceof KillProcessRequest) {
            throw new KillRequestException();
        }
    }

    private void shutdownResources() {
        LOG.debug("Shutting down all resources");
        for (Map.Entry<Integer, ProcessEntry> entry : this.idMap.entrySet()) {
            int id = entry.getKey();
            LOG.debug("{} Attempting to shutdown", (Object)id);
            ProcessEntry pe = entry.getValue();
            try {
                pe.getProcess().destroy();
                pe.getStdoutThread().interrupt();
                pe.getStderrThread().interrupt();
                pe.getStdinThread().interrupt();
                pe.getStdoutThread().join();
                pe.getStderrThread().join();
                pe.getStdinThread().join();
                pe.getExitThread().join();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (RuntimeException e) {
                LOG.error(id + " Error shutting down resource", e);
            }
            pe.getResponseBus().send(new ExitProcessNotification(id, null));
        }
        this.idMap.clear();
    }

    private static final class KillRequestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private KillRequestException() {
        }
    }
}

