/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.gateways.process;

import com.v14d4n.opentoonline.relocated.commons.io.IOUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.BasicBus;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.WriteEmptyMessage;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.ByteBufferUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProcessWriterRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWriterRunnable.class);
    private int id;
    private final OutputStream outputStream;
    private final LinkedBlockingQueue<Object> localInputBusQueue;
    private final Bus localInputBus;
    private final Bus processBus;

    ProcessWriterRunnable(int id, OutputStream outputStream, Bus processBus) {
        Validate.notNull(outputStream);
        Validate.notNull(processBus);
        this.id = id;
        this.outputStream = outputStream;
        this.localInputBusQueue = new LinkedBlockingQueue();
        this.localInputBus = new BasicBus(this.localInputBusQueue);
        this.processBus = processBus;
    }

    Bus getLocalInputBus() {
        return this.localInputBus;
    }

    @Override
    public void run() {
        LOG.debug("{} Starting up writer", (Object)this.id);
        try {
            while (true) {
                ByteBuffer sendBuffer;
                if ((sendBuffer = (ByteBuffer)this.localInputBusQueue.poll()) == null) {
                    LOG.debug("{} Write empty", (Object)this.id);
                    this.processBus.send(new WriteEmptyMessage(this.id));
                    sendBuffer = (ByteBuffer)this.localInputBusQueue.take();
                }
                byte[] buffer = ByteBufferUtils.copyContentsToArray(sendBuffer);
                this.outputStream.write(buffer);
                LOG.debug("{} Write {} bytes", (Object)this.id, (Object)buffer.length);
            }
        }
        catch (IOException | RuntimeException ioe) {
            LOG.error(this.id + " Encountered exception", ioe);
            IOUtils.closeQuietly(this.outputStream);
            LOG.debug("{} Shutting down writer", (Object)this.id);
        }
        catch (InterruptedException ie) {
            try {
                Thread.interrupted();
                LOG.debug(this.id + " Interrupted");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(this.outputStream);
                LOG.debug("{} Shutting down writer", (Object)this.id);
            }
        }
    }
}

