/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.helpers;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import java.nio.ByteBuffer;

public final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static byte[] copyContentsToArray(ByteBuffer src) {
        Validate.notNull(src);
        return ByteBufferUtils.copyContentsToArray(src, true);
    }

    public static byte[] copyContentsToArray(ByteBuffer src, boolean incrementSrc) {
        Validate.notNull(src);
        if (!incrementSrc) {
            src.mark();
        }
        ByteBuffer dst = ByteBuffer.allocate(src.remaining());
        dst.put(src);
        if (!incrementSrc) {
            src.reset();
        }
        return dst.array();
    }

    public static ByteBuffer copyContents(ByteBuffer src) {
        Validate.notNull(src);
        return ByteBufferUtils.copyContents(src, true, false);
    }

    public static ByteBuffer copyContents(ByteBuffer src, boolean incrementSrc, boolean incrementDst) {
        Validate.notNull(src);
        if (!incrementSrc) {
            src.mark();
        }
        ByteBuffer dst = ByteBuffer.allocate(src.remaining());
        dst.put(src);
        if (!incrementSrc) {
            src.reset();
        }
        if (!incrementDst) {
            dst.flip();
        }
        return dst;
    }
}

