/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.helpers;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class NetworkUtils {
    public static final InetAddress ZERO_IPV6;
    public static final InetAddress ZERO_IPV4;

    private NetworkUtils() {
    }

    public static InetAddress toAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe);
        }
    }

    public static InetSocketAddress toSocketAddress(String host, int port) {
        try {
            return new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe);
        }
    }

    public static String toIpv6AddressString(InetAddress address) {
        if (address instanceof Inet4Address) {
            byte[] bytes = address.getAddress();
            int block1 = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
            int block2 = (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            return "::ffff:" + Integer.toHexString(block1) + ":" + Integer.toHexString(block2);
        }
        if (address instanceof Inet6Address) {
            return address.getHostAddress();
        }
        throw new IllegalStateException();
    }

    public static byte[] convertAddressToIpv6Bytes(InetAddress address) {
        Validate.notNull(address);
        byte[] addrArr = address.getAddress();
        switch (addrArr.length) {
            case 4: {
                byte[] newAddrArr = new byte[16];
                newAddrArr[10] = -1;
                newAddrArr[11] = -1;
                System.arraycopy(addrArr, 0, newAddrArr, 12, 4);
                return newAddrArr;
            }
            case 16: {
                return addrArr;
            }
        }
        throw new IllegalStateException();
    }

    public static InetAddress convertBytesToAddress(byte[] buffer) {
        return NetworkUtils.convertBytesToAddress(buffer, 0, buffer.length);
    }

    public static InetAddress convertBytesToAddress(byte[] buffer, int offset, int length) {
        byte[] addr = Arrays.copyOfRange(buffer, offset, offset + length);
        try {
            InetAddress ret = InetAddress.getByAddress(addr);
            return ret;
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe);
        }
    }

    static {
        try {
            ZERO_IPV6 = InetAddress.getByName("::");
            ZERO_IPV4 = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

