/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.helpers;

import com.v14d4n.opentoonline.relocated.commons.lang3.StringUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class TextUtils {
    private static final int IPV4_COMPONENT_MAX = 255;
    private static final int IPV4_COMPONENT_MAX_SIZE = 3;
    private static final int IPV6_MAX_NUMBER_OF_COMPONENTS = 8;
    private static final int IPV6_COMPONENT_MAX_SIZE = 4;

    private TextUtils() {
    }

    public static ParsedHost splitHostAndPort(String hostPort, int defaultPort) {
        Validate.notNull(hostPort);
        Validate.inclusiveBetween(1L, 65535L, defaultPort);
        int idx = StringUtils.lastIndexOf((CharSequence)hostPort, 58);
        if (idx == -1) {
            return new ParsedHost(hostPort, defaultPort);
        }
        int port = Integer.parseInt(hostPort.substring(idx));
        Validate.inclusiveBetween(1L, 65535L, port);
        return new ParsedHost(hostPort, port);
    }

    public static String collapseWhitespace(String text) {
        Validate.notNull(text);
        StringBuilder sb = new StringBuilder(text.length());
        int len = text.length();
        boolean prevCharWhitespace = false;
        int i = 0;
        while (i < len) {
            int cp = text.codePointAt(i);
            if (Character.isWhitespace(cp)) {
                if (prevCharWhitespace) {
                    i += Character.charCount(cp);
                    continue;
                }
                prevCharWhitespace = true;
                sb.append(' ');
                i += Character.charCount(cp);
                continue;
            }
            prevCharWhitespace = false;
            sb.appendCodePoint(cp);
            i += Character.charCount(cp);
        }
        return sb.toString();
    }

    public static String findFirstBlock(String text, String begin, String end, boolean insensitiveSearch) {
        Validate.notNull(text);
        Validate.notNull(begin);
        Validate.notNull(end);
        List<String> blocks = TextUtils.findAllBlocks(text, begin, end, insensitiveSearch);
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks.get(0);
    }

    public static List<String> findAllBlocks(String text, String begin, String end, boolean insensitiveSearch) {
        Validate.notNull(text);
        Validate.notNull(begin);
        Validate.notNull(end);
        LinkedList<String> ret = new LinkedList<String>();
        int nextIdx = 0;
        while (true) {
            int endIdx;
            int startIdx;
            int n = startIdx = insensitiveSearch ? StringUtils.indexOfIgnoreCase(text, begin, nextIdx) : text.indexOf(begin, nextIdx);
            if (startIdx == -1) break;
            int n2 = endIdx = insensitiveSearch ? StringUtils.indexOfIgnoreCase(text, end, startIdx) : text.indexOf(end, startIdx += begin.length());
            if (endIdx == -1) break;
            String block = text.substring(startIdx, endIdx);
            ret.add(block);
            nextIdx = endIdx + end.length();
        }
        return ret;
    }

    public static List<String> findAllIpv4Addresses(String text) {
        Validate.notNull(text);
        LinkedList<String> ret = new LinkedList<String>();
        int len = text.length();
        int i = 0;
        while (i < len) {
            int cp = text.codePointAt(i);
            try {
                String ip = TextUtils.readIp4(text, i);
                i += ip.length();
                ret.add(ip);
            }
            catch (IllegalArgumentException iae) {
                i += Character.charCount(cp);
            }
        }
        return ret;
    }

    private static String readIp4(String text, int offset) {
        try {
            String component1 = TextUtils.readIp4Component(text, offset);
            Validate.isTrue(text.codePointAt(offset += component1.length()) == 46);
            String component2 = TextUtils.readIp4Component(text, ++offset);
            Validate.isTrue(text.codePointAt(offset += component2.length()) == 46);
            String component3 = TextUtils.readIp4Component(text, ++offset);
            Validate.isTrue(text.codePointAt(offset += component3.length()) == 46);
            String component4 = TextUtils.readIp4Component(text, ++offset);
            return component1 + '.' + component2 + '.' + component3 + '.' + component4;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String readIp4Component(String text, int offset) {
        try {
            int cp;
            int len = text.length();
            StringBuilder component = new StringBuilder();
            while (offset < len && (cp = text.codePointAt(offset)) >= 48 && cp <= 57) {
                component.appendCodePoint(cp);
                offset += Character.charCount(cp);
            }
            String componentStr = component.toString();
            Validate.isTrue(componentStr.length() <= 3);
            int componentAsNum = Integer.parseInt(componentStr);
            if (!String.valueOf(componentAsNum).equals(componentStr)) {
                throw new IllegalArgumentException();
            }
            if (componentAsNum > 255) {
                throw new IllegalArgumentException();
            }
            return componentStr;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<String> findAllIpv6Addresses(String text) {
        Validate.notNull(text);
        LinkedList<String> ret = new LinkedList<String>();
        int len = text.length();
        int i = 0;
        while (i < len) {
            int cp = text.codePointAt(i);
            try {
                String ip = TextUtils.readIp6(text, i);
                i += ip.length();
                ret.add(ip);
            }
            catch (IllegalArgumentException iae) {
                i += Character.charCount(cp);
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readIp6(String text, int offset) {
        try {
            ArrayList<String> components = new ArrayList<String>(8);
            for (int i = 0; i < 8; ++i) {
                String component = TextUtils.readIp6Component(text, offset);
                components.add(component);
                if (text.codePointAt(offset += component.length()) != 58) break;
                ++offset;
            }
            if (components.size() < 8) {
                if (!(components.size() == 3 && ((String)components.get(0)).isEmpty() && ((String)components.get(1)).isEmpty() && ((String)components.get(2)).isEmpty())) {
                    if (components.size() > 2 && ((String)components.get(0)).isEmpty() && ((String)components.get(1)).isEmpty()) {
                        Validate.isTrue(2 == TextUtils.getEmptyComponentCount(components));
                    } else if (components.size() > 2 && ((String)components.get(components.size() - 2)).isEmpty() && ((String)components.get(components.size() - 1)).isEmpty()) {
                        Validate.isTrue(2 == TextUtils.getEmptyComponentCount(components));
                    } else {
                        if (components.size() <= 2 || ((String)components.get(0)).isEmpty() || ((String)components.get(components.size() - 1)).isEmpty()) throw new IllegalArgumentException();
                        Validate.isTrue(1 == TextUtils.getEmptyComponentCount(components));
                    }
                }
            } else {
                Validate.isTrue(components.size() == 8);
                Validate.isTrue(0 == TextUtils.getEmptyComponentCount(components));
            }
            StringBuilder ip = new StringBuilder();
            for (int i = 0; i < components.size(); ++i) {
                String component = (String)components.get(i);
                ip.append(component);
                if (i == components.size() - 1) continue;
                ip.append(':');
            }
            return ip.toString();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static int getEmptyComponentCount(List<String> components) {
        int emptyComponentCount = 0;
        for (String component : components) {
            if (!component.isEmpty()) continue;
            ++emptyComponentCount;
        }
        return emptyComponentCount;
    }

    private static String readIp6Component(String text, int offset) {
        try {
            int cp;
            int len = text.length();
            StringBuilder component = new StringBuilder();
            while (offset < len && ((cp = text.codePointAt(offset)) >= 48 && cp <= 57 || cp >= 97 && cp <= 102 || cp >= 65 && cp <= 70)) {
                component.appendCodePoint(cp);
                offset += Character.charCount(cp);
            }
            String componentStr = component.toString();
            Validate.isTrue(componentStr.length() <= 4);
            return componentStr;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class ParsedHost {
        private final String host;
        private final int port;

        private ParsedHost(String host, int port) {
            Validate.notNull(host);
            Validate.inclusiveBetween(1L, 65535L, port);
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

