/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mapper;

import com.v14d4n.opentoonline.relocated.commons.collections4.bidimap.DualHashBidiMap;
import com.v14d4n.opentoonline.relocated.commons.collections4.multimap.ArrayListValuedHashMap;
import com.v14d4n.opentoonline.relocated.commons.collections4.set.UnmodifiableSet;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.BasicBus;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CloseNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CreateTcpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.CreateUdpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetLocalIpAddressesNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetLocalIpAddressesNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetNextIdNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.GetNextIdNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.IdentifiableErrorNetworkResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ReadClosedTcpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ReadTcpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.ReadUdpNetworkNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteTcpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.network.internalmessages.WriteUdpNetworkRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.CloseProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.CreateProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ErrorProcessResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ExitProcessNotification;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.GetNextIdProcessRequest;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.GetNextIdProcessResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.IdentifiableErrorProcessResponse;
import com.v14d4n.opentoonline.relocated.portmapper.gateways.process.internalmessages.ReadProcessNotification;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapperIoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MapperIoUtils.class);
    public static final UnmodifiableSet<InetAddress> PRESET_IPV4_GATEWAY_ADDRESSES;

    private MapperIoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runProcesses(Bus processBus, Collection<ProcessRequest> reqs, long timeout) throws InterruptedException {
        Iterator iterator;
        Validate.notNull(processBus);
        Validate.notNull(reqs);
        Validate.noNullElements(reqs);
        LOG.debug("Running processes {} with duration {}", (Object)reqs, (Object)timeout);
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BasicBus selfBus = new BasicBus(queue);
        long endTime = System.currentTimeMillis() + timeout;
        HashMap<Integer, ProcessRequest> processes = new HashMap<Integer, ProcessRequest>();
        HashMap<Integer, ByteArrayOutputStream> stdoutBuffers = new HashMap<Integer, ByteArrayOutputStream>();
        HashMap<Integer, ByteArrayOutputStream> stderrBuffers = new HashMap<Integer, ByteArrayOutputStream>();
        try {
            for (ProcessRequest processRequest : reqs) {
                long sleepTime = endTime - System.currentTimeMillis();
                Validate.validState(sleepTime > 0L, "Failed to create all processes in time", new Object[0]);
                processBus.send(new GetNextIdProcessRequest(selfBus));
                GetNextIdProcessResponse resp = (GetNextIdProcessResponse)queue.poll(sleepTime, TimeUnit.MILLISECONDS);
                int id = resp.getId();
                stdoutBuffers.put(id, new ByteArrayOutputStream());
                processes.put(id, processRequest);
            }
            for (Map.Entry entry : processes.entrySet()) {
                int id = (Integer)entry.getKey();
                ProcessRequest req = (ProcessRequest)entry.getValue();
                LOG.debug("Starting process {}", (Object)req);
                processBus.send(new CreateProcessRequest(id, selfBus, req.getExecutable(), req.getParameters()));
            }
            int runningProcs = reqs.size();
            while (runningProcs > 0) {
                long l = endTime - System.currentTimeMillis();
                if (l <= 0L) {
                    break;
                }
                Object resp = queue.poll(l, TimeUnit.MILLISECONDS);
                if (resp instanceof ReadProcessNotification) {
                    ByteArrayOutputStream baos;
                    ReadProcessNotification readResp = (ReadProcessNotification)resp;
                    Integer id = readResp.getId();
                    switch (readResp.getReadType()) {
                        case STDOUT: {
                            baos = (ByteArrayOutputStream)stdoutBuffers.get(id);
                            if (baos != null) break;
                            baos = new ByteArrayOutputStream();
                            stdoutBuffers.put(id, baos);
                            break;
                        }
                        case STDERR: {
                            baos = (ByteArrayOutputStream)stderrBuffers.get(id);
                            if (baos != null) break;
                            baos = new ByteArrayOutputStream();
                            stderrBuffers.put(id, baos);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    try {
                        baos.write(readResp.getData());
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException();
                    }
                }
                if (resp instanceof ExitProcessNotification) {
                    --runningProcs;
                    continue;
                }
                if (resp instanceof IdentifiableErrorProcessResponse) {
                    --runningProcs;
                    continue;
                }
                if (!(resp instanceof ErrorProcessResponse)) continue;
                --runningProcs;
            }
        }
        finally {
            iterator = stdoutBuffers.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                processBus.send(new CloseProcessRequest(n));
            }
        }
        iterator = stdoutBuffers.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            ByteArrayOutputStream outOs = (ByteArrayOutputStream)stdoutBuffers.get(n);
            ByteArrayOutputStream errOs = (ByteArrayOutputStream)stderrBuffers.get(n);
            byte[] outData = outOs == null ? new byte[]{} : outOs.toByteArray();
            byte[] errData = errOs == null ? new byte[]{} : errOs.toByteArray();
            String out = new String(outData, Charset.forName("US-ASCII"));
            String err = new String(errData, Charset.forName("US-ASCII"));
            LOG.debug("Process response\nSTDOUT\n{}\nSTDERR\n{}", (Object)out, (Object)err);
            ProcessRequest req = (ProcessRequest)processes.get(n);
            req.setOutput(out);
            req.setError(err);
        }
    }

    public static Set<InetAddress> convertToAddressSet(List<String> addresses) {
        Validate.notNull(addresses);
        Validate.noNullElements(addresses);
        HashSet<InetAddress> ret = new HashSet<InetAddress>();
        for (String address : addresses) {
            try {
                ret.add(InetAddress.getByName(address));
            }
            catch (UnknownHostException uhe) {}
        }
        return ret;
    }

    public static Set<InetAddress> getLocalIpAddresses(Bus networkBus) throws InterruptedException {
        Validate.notNull(networkBus);
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BasicBus selfBus = new BasicBus(queue);
        LOG.debug("Getting local IP addresses");
        networkBus.send(new GetLocalIpAddressesNetworkRequest(selfBus));
        GetLocalIpAddressesNetworkResponse localIpsResp = (GetLocalIpAddressesNetworkResponse)queue.poll(10000L, TimeUnit.MILLISECONDS);
        Validate.validState(localIpsResp != null);
        LOG.debug("Got local IP addresses {}", (Object)localIpsResp);
        return localIpsResp.getLocalAddresses();
    }

    public static long[] calculateExponentialBackoffTimes(int attempts) {
        Validate.isTrue(attempts >= 0);
        long[] ret = new long[attempts];
        long nextTime = 250L;
        for (int i = 0; i < attempts; ++i) {
            ret[i] = nextTime;
            nextTime *= 2L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performUdpRequests(Bus networkBus, Collection<UdpRequest> reqs, boolean broadcastBehaviour, long ... attemptDurations) throws InterruptedException {
        Validate.notNull(networkBus);
        Validate.notNull(reqs);
        Validate.noNullElements(reqs);
        Validate.notNull(attemptDurations);
        for (long attemptDuration : attemptDurations) {
            Validate.isTrue(attemptDuration >= 0L);
        }
        LOG.debug("Performing udp requests {} with durations {}", (Object)reqs, (Object)attemptDurations);
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BasicBus selfBus = new BasicBus(queue);
        DualHashBidiMap<InetAddress, Integer> addressToSocketId = new DualHashBidiMap<InetAddress, Integer>();
        ArrayListValuedHashMap<Integer, UdpRequest> socketIdToRequests = new ArrayListValuedHashMap<Integer, UdpRequest>();
        try {
            long endCreateTime = System.currentTimeMillis() + 3000L;
            for (UdpRequest udpRequest : reqs) {
                long sleepTime = endCreateTime - System.currentTimeMillis();
                Validate.validState(sleepTime > 0L);
                InetAddress source = udpRequest.getSourceAddress();
                if (addressToSocketId.containsKey(source) || udpRequest.getDestinationSocketAddress().getAddress().equals(NetworkUtils.ZERO_IPV4) || udpRequest.getDestinationSocketAddress().getAddress().equals(NetworkUtils.ZERO_IPV6)) continue;
                LOG.debug("Creating socket ID for {}", (Object)source);
                networkBus.send(new GetNextIdNetworkRequest(selfBus));
                Object resp = queue.poll(sleepTime, TimeUnit.MILLISECONDS);
                int id = ((GetNextIdNetworkResponse)resp).getId();
                addressToSocketId.put(source, id);
                LOG.debug("Socket ID for {} is {}", (Object)source, (Object)id);
            }
            for (Map.Entry entry : addressToSocketId.entrySet()) {
                int id = (Integer)entry.getValue();
                InetAddress source = (InetAddress)entry.getKey();
                LOG.debug("Creating UDP socket {}", (Object)source);
                networkBus.send(new CreateUdpNetworkRequest(id, selfBus, source));
            }
            for (UdpRequest udpRequest : reqs) {
                int id = (Integer)addressToSocketId.get(udpRequest.getSourceAddress());
                socketIdToRequests.put(id, udpRequest);
            }
            LinkedList<Long> remainingAttemptDurations = new LinkedList<Long>();
            for (long attemptDuration : attemptDurations) {
                remainingAttemptDurations.add(attemptDuration);
            }
            while (!socketIdToRequests.isEmpty() && !remainingAttemptDurations.isEmpty()) {
                long sleepTime;
                for (UdpRequest req : socketIdToRequests.values()) {
                    int id = (Integer)addressToSocketId.get(req.getSourceAddress());
                    Object request = req.getRequest();
                    byte[] reqBytes = req.getRequestToBytesTransformer().create(request);
                    InetSocketAddress dst = req.getDestinationSocketAddress();
                    networkBus.send(new WriteUdpNetworkRequest(id, dst, reqBytes));
                }
                long l = (Long)remainingAttemptDurations.poll();
                long endTime = System.currentTimeMillis() + l;
                block12: while ((sleepTime = endTime - System.currentTimeMillis()) > 0L) {
                    Object netResp = queue.poll(sleepTime, TimeUnit.MILLISECONDS);
                    if (netResp == null) {
                        LOG.debug("Timed out waiting for response");
                        continue;
                    }
                    if (!(netResp instanceof ReadUdpNetworkNotification)) {
                        LOG.debug("Expected a read but encountered {} -- skipping", netResp);
                        continue;
                    }
                    ReadUdpNetworkNotification readNetResp = (ReadUdpNetworkNotification)netResp;
                    int id = readNetResp.getId();
                    InetSocketAddress remoteSocketAddress = readNetResp.getRemoteAddress();
                    Iterator it = socketIdToRequests.get(id).iterator();
                    while (it.hasNext()) {
                        UdpRequest pendingReq = (UdpRequest)it.next();
                        if (!broadcastBehaviour && !pendingReq.getDestinationSocketAddress().equals(remoteSocketAddress)) continue;
                        byte[] respData = readNetResp.getData();
                        try {
                            Object response = pendingReq.getBytesToResponseTransformer().create(respData);
                            LOG.debug("Parsed the following response to {} from {}", response, (Object)respData);
                            pendingReq.addResponse(response);
                            if (broadcastBehaviour) continue block12;
                            LOG.debug("Removed request from send queue");
                            it.remove();
                        }
                        catch (RuntimeException e) {
                            LOG.error("Encountered error while parsing response from {}", (Object)respData, (Object)e);
                        }
                        continue block12;
                    }
                }
            }
        }
        finally {
            Iterator iterator = addressToSocketId.values().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                networkBus.send(new CloseNetworkRequest(id));
            }
        }
        LOG.debug("Completed udp requests {}", (Object)reqs);
    }

    public static void performBatchedTcpRequests(Bus networkBus, Collection<TcpRequest> reqs, int batchSize, long ... attemptDurations) throws InterruptedException {
        Validate.notNull(networkBus);
        Validate.notNull(reqs);
        Validate.notNull(attemptDurations);
        Validate.isTrue(batchSize >= 1);
        for (long attemptDuration : attemptDurations) {
            Validate.isTrue(attemptDuration >= 0L);
        }
        LOG.debug("Performing tcp requests {} with durations ", (Object)reqs, (Object)attemptDurations);
        ArrayListValuedHashMap<InetSocketAddress, TcpRequest> ret = new ArrayListValuedHashMap<InetSocketAddress, TcpRequest>();
        for (TcpRequest req : reqs) {
            InetSocketAddress dst = req.getDestinationSocketAddress();
            ret.put(dst, req);
        }
        LinkedList batches = new LinkedList();
        int counter = 0;
        while (true) {
            LinkedList batch = new LinkedList();
            int n = counter * 3;
            int end = (counter + 1) * 3;
            for (InetSocketAddress destinationAddress : ret.keySet()) {
                Collection destinationRequests = ret.get((Object)destinationAddress);
                if (n >= destinationRequests.size()) continue;
                int size = destinationRequests.size();
                int actualEnd = Math.min(end, size);
                batch.addAll(destinationRequests.subList(n, actualEnd));
            }
            if (batch.isEmpty()) break;
            batches.add(batch);
            ++counter;
        }
        for (List list : batches) {
            LOG.debug("Performing batch");
            MapperIoUtils.performTcpRequests(networkBus, list, attemptDurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public static void performTcpRequests(Bus networkBus, Collection<TcpRequest> reqs, long ... attemptDurations) throws InterruptedException {
        Validate.notNull(networkBus);
        Validate.notNull(reqs);
        Validate.noNullElements(reqs);
        Validate.notNull(attemptDurations);
        for (long attemptDuration : attemptDurations) {
            Validate.isTrue(attemptDuration >= 0L);
        }
        LOG.debug("Performing tcp requests {} with durations ", (Object)reqs, (Object)attemptDurations);
        LinkedList<Long> remainingAttemptDurations = new LinkedList<Long>();
        for (long attemptDuration : attemptDurations) {
            remainingAttemptDurations.add(attemptDuration);
        }
        while (!remainingAttemptDurations.isEmpty()) {
            TcpRequest req;
            LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
            BasicBus selfBus = new BasicBus(queue);
            long timeout = (Long)remainingAttemptDurations.poll();
            long endTime = System.currentTimeMillis() + timeout;
            HashMap<Integer, TcpRequest> sockets = new HashMap<Integer, TcpRequest>();
            HashMap<Integer, ByteArrayOutputStream> readBuffers = new HashMap<Integer, ByteArrayOutputStream>();
            try {
                long sleepTime;
                for (TcpRequest req2 : reqs) {
                    sleepTime = endTime - System.currentTimeMillis();
                    Validate.validState(sleepTime > 0L);
                    LOG.debug("Creating socket ID for {}", (Object)req2);
                    networkBus.send(new GetNextIdNetworkRequest(selfBus));
                    Object resp = queue.poll(sleepTime, TimeUnit.MILLISECONDS);
                    int id = ((GetNextIdNetworkResponse)resp).getId();
                    sockets.put(id, req2);
                    readBuffers.put(id, new ByteArrayOutputStream());
                    LOG.debug("Socket ID for {} is {}", (Object)req2, (Object)id);
                }
                for (Map.Entry entry : sockets.entrySet()) {
                    sleepTime = endTime - System.currentTimeMillis();
                    Validate.validState(sleepTime > 0L);
                    int id = (Integer)entry.getKey();
                    TcpRequest req3 = (TcpRequest)entry.getValue();
                    LOG.debug("Creating TCP socket {}", (Object)id);
                    InetAddress destinationAddress = req3.getDestinationSocketAddress().getAddress();
                    int destinationPort = req3.getDestinationSocketAddress().getPort();
                    networkBus.send(new CreateTcpNetworkRequest(id, selfBus, req3.getSourceAddress(), destinationAddress, destinationPort));
                }
                for (Map.Entry entry : sockets.entrySet()) {
                    int id = (Integer)entry.getKey();
                    req = (TcpRequest)entry.getValue();
                    Object request = req.getRequest();
                    byte[] reqBytes = req.getRequestToBytesTransformer().create(request);
                    networkBus.send(new WriteTcpNetworkRequest(id, reqBytes));
                }
                HashSet activeSocketIds = new HashSet(sockets.keySet());
                while (!activeSocketIds.isEmpty()) {
                    int id;
                    long sleepTime2 = endTime - System.currentTimeMillis();
                    if (sleepTime2 <= 0L) {
                        break;
                    }
                    Object resp = queue.poll(sleepTime2, TimeUnit.MILLISECONDS);
                    if (resp instanceof ReadTcpNetworkNotification) {
                        ReadTcpNetworkNotification readResp = (ReadTcpNetworkNotification)resp;
                        id = readResp.getId();
                        ByteArrayOutputStream baos = (ByteArrayOutputStream)readBuffers.get(id);
                        Validate.validState(baos != null);
                        try {
                            baos.write(readResp.getData());
                            continue;
                        }
                        catch (IOException ioe) {
                            throw new IllegalStateException();
                        }
                    }
                    if (resp instanceof IdentifiableErrorNetworkResponse) {
                        IdentifiableErrorNetworkResponse errorResp = (IdentifiableErrorNetworkResponse)resp;
                        id = errorResp.getId();
                        activeSocketIds.remove(id);
                        continue;
                    }
                    if (!(resp instanceof ReadClosedTcpNetworkNotification)) continue;
                    ReadClosedTcpNetworkNotification closedResp = (ReadClosedTcpNetworkNotification)resp;
                    id = closedResp.getId();
                    activeSocketIds.remove(id);
                }
            }
            finally {
                Iterator<Object> iterator = sockets.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    networkBus.send(new CloseNetworkRequest(id));
                }
            }
            for (Map.Entry entry : readBuffers.entrySet()) {
                int id = (Integer)entry.getKey();
                req = (TcpRequest)sockets.get(id);
                byte[] respData = ((ByteArrayOutputStream)entry.getValue()).toByteArray();
                try {
                    Object response = req.getBytesToResponseTransformer().create(respData);
                    LOG.debug("Parsed the following response to {} from {}", response, (Object)respData);
                    req.setResponse(response);
                }
                catch (RuntimeException e) {
                    LOG.error("Encountered error while parsing response from {}", (Object)respData, (Object)e);
                }
            }
        }
        LOG.debug("Completed tcp requests {}", (Object)reqs);
    }

    static {
        Set<InetAddress> gatewayAddresses = MapperIoUtils.convertToAddressSet(Arrays.asList("192.168.1.1", "192.168.0.1", "192.168.1.254", "10.0.0.138", "192.168.1.1", "192.168.1.10.1", "192.168.1.1", "192.168.0.1", "192.168.2.1", "192.168.254.254", "192.168.1.1", "192.168.2.1", "192.168.2.1", "192.168.2.1", "10.0.1.1", "192.168.3.1", "192.168.1.1", "192.168.2.1", "10.10.1.1", "192.168.1.1", "192.168.2.1", "192.168.1.254", "192.168.254.254", "192.168.1.1", "192.168.2.1", "10.0.0.2", "10.1.1.1", "192.168.1.254", "10.0.0.2", "192.168.1.1", "192.168.11.1", "192.168.1.1", "192.168.1.1", "192.168.0.30", "192.168.0.50", "10.0.0.1", "10.0.0.2", "192.168.1.1", "192.168.0.1", "192.168.0.10", "192.168.0.101", "192.168.0.30", "192.168.0.50", "192.168.1.254", "192.168.15.1", "192.168.254.254", "10.0.0.1", "10.0.0.2", "10.1.1.1", "10.90.90.90", "192.168.2.1", "192.168.1.1", "192.168.0.1", "192.168.8.1", "192.168.1.254", "192.168.1.200", "192.168.1.254", "192.168.1.1", "192.168.0.1", "192.168.3.1", "192.168.8.1", "192.168.100.1", "10.0.0.138", "192.168.0.1", "192.168.123.254", "192.168.1.1", "192.168.0.1", "192.168.1.10", "192.168.1.210", "192.168.1.254", "192.168.1.99", "192.168.15.1", "192.168.16.1", "192.168.2.1", "192.168.2.1", "192.168.0.1", "192.168.10.1", "192.168.15.1", "192.168.20.1", "192.168.30.1", "192.168.62.1", "192.168.100.1", "192.168.102.1", "192.168.1.254", "192.168.1.254", "192.168.0.1", "192.168.0.227", "192.168.1.1", "192.168.10.50", "192.168.20.1", "10.0.0.138", "192.168.0.1", "192.168.1.254", "192.168.1.1", "192.168.0.1", "192.168.1.254", "192.168.1.1", "192.168.10.1", "192.168.16.1", "192.168.123.254", "192.168.0.1", "192.168.1.1", "192.168.0.1", "192.168.1.254", "192.168.2.1", "192.168.254.254", "10.0.0.138", "10.0.0.2", "192.168.0.1", "192.168.1.254", "192.168.123.254", "10.0.0.1", "192.168.1.1", "192.168.0.1", "192.168.2.1", "10.0.0.1", "10.1.10.1", "192.168.0.3", "192.168.168.168", "10.0.0.138", "192.168.1.254", "192.168.15.1", "192.168.50.1", "192.168.55.1", "192.168.251.1", "192.168.1.1", "192.168.0.1", "192.168.0.1", "192.168.1.254", "192.168.100.1", "192.168.1.1", "192.168.0.1", "192.168.0.254", "192.168.1.1", "192.168.0.1", "192.168.0.30", "192.168.0.100", "192.168.1.100", "192.168.1.254", "192.168.10.1", "192.168.10.10", "192.168.10.100", "192.168.2.1", "192.168.223.100", "192.168.1.1", "192.168.2.1", "192.168.123.254", "192.168.1.1", "192.168.2.1", "192.168.4.1", "192.168.10.1", "192.168.1.254", "10.0.0.2", "10.0.0.138", "192.168.1.1", "192.168.0.1", "192.168.100.100", "192.168.1.254", "192.168.2.1", "192.168.2.254", "192.168.1.1", "192.168.0.1", "192.168.2.1", "192.168.4.1", "192.168.10.1", "192.168.1.254", "192.168.254.254", "10.0.0.2", "10.0.0.138"));
        PRESET_IPV4_GATEWAY_ADDRESSES = (UnmodifiableSet)UnmodifiableSet.unmodifiableSet(gatewayAddresses);
    }

    public static interface BytesToResponseTransformer {
        public Object create(byte[] var1);
    }

    public static interface RequestToBytesTransformer {
        public byte[] create(Object var1);
    }

    public static final class TcpRequest {
        private final InetAddress sourceAddress;
        private final InetSocketAddress destinationSocketAddress;
        private final Object request;
        private Object response;
        private final RequestToBytesTransformer requestToBytesTransformer;
        private final BytesToResponseTransformer bytesToResponseTransformer;
        private Object other;

        public TcpRequest(InetAddress sourceAddress, InetSocketAddress destinationSocketAddress, Object request, RequestToBytesTransformer requestToBytesTransformer, BytesToResponseTransformer bytesToResponseTransformer) {
            Validate.notNull(sourceAddress);
            Validate.notNull(destinationSocketAddress);
            Validate.notNull(request);
            Validate.notNull(requestToBytesTransformer);
            Validate.notNull(bytesToResponseTransformer);
            this.sourceAddress = sourceAddress;
            this.destinationSocketAddress = destinationSocketAddress;
            this.request = request;
            this.requestToBytesTransformer = requestToBytesTransformer;
            this.bytesToResponseTransformer = bytesToResponseTransformer;
        }

        public InetAddress getSourceAddress() {
            return this.sourceAddress;
        }

        public InetSocketAddress getDestinationSocketAddress() {
            return this.destinationSocketAddress;
        }

        public RequestToBytesTransformer getRequestToBytesTransformer() {
            return this.requestToBytesTransformer;
        }

        public BytesToResponseTransformer getBytesToResponseTransformer() {
            return this.bytesToResponseTransformer;
        }

        public Object getRequest() {
            return this.request;
        }

        public Object getResponse() {
            return this.response;
        }

        void setResponse(Object response) {
            this.response = response;
        }

        public Object getOther() {
            return this.other;
        }

        public void setOther(Object other) {
            this.other = other;
        }

        public String toString() {
            return "TcpRequest{sourceAddress=" + this.sourceAddress + ", destinationSocketAddress=" + this.destinationSocketAddress + ", request=" + this.request + ", response=" + this.response + ", requestToBytesTransformer=" + this.requestToBytesTransformer + ", bytesToResponseTransformer=" + this.bytesToResponseTransformer + ", other=" + this.other + '}';
        }
    }

    public static final class UdpRequest {
        private final InetAddress sourceAddress;
        private final InetSocketAddress destinationSocketAddress;
        private final Object request;
        private final List<Object> responses;
        private final RequestToBytesTransformer requestToBytesTransformer;
        private final BytesToResponseTransformer bytesToResponseTransformer;
        private Object other;

        public UdpRequest(InetAddress sourceAddress, InetSocketAddress destinationSocketAddress, Object request, RequestToBytesTransformer requestToBytesTransformer, BytesToResponseTransformer bytesToResponseTransformer) {
            Validate.notNull(sourceAddress);
            Validate.notNull(destinationSocketAddress);
            Validate.notNull(request);
            Validate.notNull(requestToBytesTransformer);
            Validate.notNull(bytesToResponseTransformer);
            this.sourceAddress = sourceAddress;
            this.destinationSocketAddress = destinationSocketAddress;
            this.request = request;
            this.responses = new LinkedList<Object>();
            this.requestToBytesTransformer = requestToBytesTransformer;
            this.bytesToResponseTransformer = bytesToResponseTransformer;
        }

        public InetAddress getSourceAddress() {
            return this.sourceAddress;
        }

        public InetSocketAddress getDestinationSocketAddress() {
            return this.destinationSocketAddress;
        }

        public RequestToBytesTransformer getRequestToBytesTransformer() {
            return this.requestToBytesTransformer;
        }

        public BytesToResponseTransformer getBytesToResponseTransformer() {
            return this.bytesToResponseTransformer;
        }

        public Object getRequest() {
            return this.request;
        }

        public Object getResponse() {
            return this.responses.isEmpty() ? null : this.responses.get(0);
        }

        public List<Object> getResponses() {
            return new ArrayList<Object>(this.responses);
        }

        void addResponse(Object response) {
            Validate.notNull(response);
            this.responses.add(response);
        }

        public Object getOther() {
            return this.other;
        }

        public void setOther(Object other) {
            this.other = other;
        }

        public String toString() {
            return "UdpRequest{sourceAddress=" + this.sourceAddress + ", destinationSocketAddress=" + this.destinationSocketAddress + ", request=" + this.request + ", responses=" + this.responses + ", requestToBytesTransformer=" + this.requestToBytesTransformer + ", bytesToResponseTransformer=" + this.bytesToResponseTransformer + ", other=" + this.other + '}';
        }
    }

    public static final class ProcessRequest {
        private final String executable;
        private final String[] parameters;
        private String output;
        private String error;

        public ProcessRequest(String executable, String ... parameters) {
            Validate.notNull(executable);
            Validate.notNull(parameters);
            Validate.noNullElements(parameters);
            this.executable = executable;
            this.parameters = Arrays.copyOf(parameters, parameters.length);
        }

        public String[] getParameters() {
            return Arrays.copyOf(this.parameters, this.parameters.length);
        }

        public String getExecutable() {
            return this.executable;
        }

        public String getOutput() {
            return this.output;
        }

        void setOutput(String output) {
            this.output = output;
        }

        public String getError() {
            return this.error;
        }

        void setError(String error) {
            this.error = error;
        }

        public String toString() {
            return "RunProcessRequest{executable=" + this.executable + ", parameters=" + Arrays.toString(this.parameters) + ", output=" + this.output + ", error=" + this.error + '}';
        }
    }
}

