/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import java.net.InetAddress;

final class NatPmpMappedPort
implements MappedPort {
    private int internalPort;
    private int externalPort;
    private InetAddress externalAddress;
    private PortType portType;
    private long lifetime;

    NatPmpMappedPort(int internalPort, int externalPort, InetAddress externalAddress, PortType portType, long duration) {
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, 65535L, externalPort);
        Validate.notNull(externalAddress);
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, duration);
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.externalAddress = externalAddress;
        this.portType = portType;
        this.lifetime = duration;
    }

    @Override
    public int getInternalPort() {
        return this.internalPort;
    }

    @Override
    public int getExternalPort() {
        return this.externalPort;
    }

    @Override
    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    @Override
    public PortType getPortType() {
        return this.portType;
    }

    @Override
    public long getLifetime() {
        return this.lifetime;
    }

    public String toString() {
        return "NatPmpMappedPort{internalPort=" + this.internalPort + ", externalPort=" + this.externalPort + ", externalAddress=" + this.externalAddress + ", portType=" + (Object)((Object)this.portType) + ", lifetime=" + this.lifetime + '}';
    }
}

