/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.TextUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MapperIoUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.NatPmpMappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.NatPmpResultCode;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.ExternalAddressNatPmpRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.ExternalAddressNatPmpResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.MappingNatPmpRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.MappingNatPmpResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.TcpMappingNatPmpRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.TcpMappingNatPmpResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.UdpMappingNatPmpRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.UdpMappingNatPmpResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NatPmpPortMapper
implements PortMapper {
    private static final Logger LOG = LoggerFactory.getLogger(NatPmpPortMapper.class);
    private static final int PORT = 5351;
    private Bus networkBus;
    private InetAddress internalAddress;
    private InetAddress gatewayAddress;

    public static List<NatPmpPortMapper> identify(Bus networkBus, Bus processBus, InetAddress ... additionalIps) throws InterruptedException {
        LOG.info("Attempting to identify devices");
        Validate.notNull(networkBus);
        Validate.notNull(processBus);
        Validate.notNull(additionalIps);
        Validate.noNullElements(additionalIps);
        ArrayList<MapperIoUtils.ProcessRequest> processReqs = new ArrayList<MapperIoUtils.ProcessRequest>();
        processReqs.add(new MapperIoUtils.ProcessRequest("netstat", "-rn"));
        processReqs.add(new MapperIoUtils.ProcessRequest("route", "-n"));
        processReqs.add(new MapperIoUtils.ProcessRequest("route", "-n", "get", "default"));
        processReqs.add(new MapperIoUtils.ProcessRequest("ipconfig", new String[0]));
        processReqs.add(new MapperIoUtils.ProcessRequest("ifconfig", new String[0]));
        MapperIoUtils.runProcesses(processBus, processReqs, 10000L);
        HashSet<InetAddress> potentialGatewayAddresses = new HashSet<InetAddress>();
        potentialGatewayAddresses.addAll(MapperIoUtils.PRESET_IPV4_GATEWAY_ADDRESSES);
        potentialGatewayAddresses.addAll(Arrays.asList(additionalIps));
        for (MapperIoUtils.ProcessRequest req : processReqs) {
            List<String> netstatOutputIpv4Addresses = TextUtils.findAllIpv4Addresses(req.getOutput());
            List<String> netstatOutputIpv6Addresses = TextUtils.findAllIpv6Addresses(req.getOutput());
            List<String> netstatErrorIpv4Addresses = TextUtils.findAllIpv4Addresses(req.getError());
            List<String> netstatErrorIpv6Addresses = TextUtils.findAllIpv6Addresses(req.getError());
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatOutputIpv4Addresses));
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatOutputIpv6Addresses));
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatErrorIpv4Addresses));
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatErrorIpv6Addresses));
        }
        Iterator pgaIt = potentialGatewayAddresses.iterator();
        while (pgaIt.hasNext()) {
            InetAddress address = (InetAddress)pgaIt.next();
            if (!address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress()) continue;
            pgaIt.remove();
        }
        LinkedList<MapperIoUtils.UdpRequest> udpReqs = new LinkedList<MapperIoUtils.UdpRequest>();
        Set<InetAddress> sourceAddresses = MapperIoUtils.getLocalIpAddresses(networkBus);
        for (InetAddress sourceAddress : sourceAddresses) {
            for (InetAddress gatewayAddress : potentialGatewayAddresses) {
                if (!sourceAddress.getClass().equals(gatewayAddress.getClass()) || gatewayAddress.isLoopbackAddress()) continue;
                MapperIoUtils.UdpRequest udpReq = NatPmpPortMapper.createGetExternalIpUdpRequest(sourceAddress, gatewayAddress);
                udpReqs.add(udpReq);
            }
        }
        MapperIoUtils.performUdpRequests(networkBus, udpReqs, false, 1000L, 1000L, 1000L, 1000L, 1000L);
        LinkedList<NatPmpPortMapper> mappers = new LinkedList<NatPmpPortMapper>();
        for (MapperIoUtils.UdpRequest udpReq : udpReqs) {
            if (udpReq.getResponse() == null) continue;
            NatPmpPortMapper portMapper = new NatPmpPortMapper(networkBus, udpReq.getSourceAddress(), udpReq.getDestinationSocketAddress().getAddress());
            mappers.add(portMapper);
        }
        return mappers;
    }

    public NatPmpPortMapper(Bus networkBus, InetAddress internalAddress, InetAddress gatewayAddress) {
        Validate.notNull(networkBus);
        Validate.notNull(internalAddress);
        Validate.notNull(gatewayAddress);
        this.networkBus = networkBus;
        this.internalAddress = internalAddress;
        this.gatewayAddress = gatewayAddress;
    }

    @Override
    public MappedPort mapPort(PortType portType, int internalPort, int externalPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to map {} Internal:{} External:{} Lifetime:{}", new Object[]{portType, internalPort, externalPort, lifetime});
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        MapperIoUtils.UdpRequest externalIpReq = NatPmpPortMapper.createGetExternalIpUdpRequest(this.internalAddress, this.gatewayAddress);
        MapperIoUtils.performUdpRequests(this.networkBus, Collections.singleton(externalIpReq), false, MapperIoUtils.calculateExponentialBackoffTimes(4));
        if (externalIpReq.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to getting external IP");
        }
        InetAddress externalAddress = ((ExternalAddressNatPmpResponse)externalIpReq.getResponse()).getAddress();
        MapperIoUtils.UdpRequest mapIpReq = NatPmpPortMapper.createMappingUdpRequest(this.internalAddress, this.gatewayAddress, portType, internalPort, externalPort, lifetime);
        MapperIoUtils.performUdpRequests(this.networkBus, Collections.singleton(mapIpReq), false, MapperIoUtils.calculateExponentialBackoffTimes(4));
        if (mapIpReq.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to mapping port");
        }
        MappingNatPmpResponse mappingResp = (MappingNatPmpResponse)mapIpReq.getResponse();
        NatPmpMappedPort mappedPort = new NatPmpMappedPort(mappingResp.getInternalPort(), mappingResp.getExternalPort(), externalAddress, portType, mappingResp.getLifetime());
        LOG.debug("Map successful {}", (Object)mappedPort);
        return mappedPort;
    }

    @Override
    public void unmapPort(MappedPort mappedPort) throws InterruptedException {
        LOG.info("Attempting to unmap {}", (Object)mappedPort);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof NatPmpMappedPort);
        PortType portType = mappedPort.getPortType();
        int internalPort = mappedPort.getInternalPort();
        MapperIoUtils.UdpRequest mapIpReq = NatPmpPortMapper.createMappingUdpRequest(this.internalAddress, this.gatewayAddress, portType, internalPort, 0, 0L);
        MapperIoUtils.performUdpRequests(this.networkBus, Collections.singleton(mapIpReq), false, MapperIoUtils.calculateExponentialBackoffTimes(4));
        if (mapIpReq.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to mapping port");
        }
        LOG.debug("Unmap successful {}", (Object)mappedPort);
    }

    @Override
    public MappedPort refreshPort(MappedPort mappedPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to refresh mapping {} for {}", (Object)mappedPort, (Object)lifetime);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof NatPmpMappedPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        MappedPort newMappedPort = this.mapPort(mappedPort.getPortType(), mappedPort.getInternalPort(), mappedPort.getExternalPort(), lifetime);
        if (mappedPort.getExternalPort() != newMappedPort.getExternalPort() || !Objects.equals(mappedPort.getExternalAddress(), newMappedPort.getExternalAddress())) {
            LOG.warn("Failed refresh mapping {}: ", (Object)mappedPort, (Object)newMappedPort);
            try {
                this.unmapPort(newMappedPort);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            throw new IllegalStateException("External IP/port changed from " + mappedPort.getExternalAddress() + ":" + mappedPort.getExternalPort() + " to " + newMappedPort.getExternalAddress() + ":" + newMappedPort.getExternalPort());
        }
        LOG.debug("Mapping refreshed {}: ", (Object)mappedPort, (Object)newMappedPort);
        return newMappedPort;
    }

    private static MapperIoUtils.UdpRequest createGetExternalIpUdpRequest(InetAddress internalAddress, InetAddress gatewayAddress) {
        MapperIoUtils.UdpRequest externalIpReq = new MapperIoUtils.UdpRequest(internalAddress, new InetSocketAddress(gatewayAddress, 5351), new ExternalAddressNatPmpRequest(), new MapperIoUtils.RequestToBytesTransformer(){

            @Override
            public byte[] create(Object request) {
                return ((ExternalAddressNatPmpRequest)request).dump();
            }
        }, new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                ExternalAddressNatPmpResponse resp = new ExternalAddressNatPmpResponse(buffer);
                if (resp.getResultCode() != NatPmpResultCode.SUCCESS.ordinal()) {
                    throw new IllegalArgumentException();
                }
                return resp;
            }
        });
        return externalIpReq;
    }

    private static MapperIoUtils.UdpRequest createMappingUdpRequest(InetAddress internalAddress, InetAddress gatewayAddress, PortType portType, int internalPort, int externalPort, long lifetime) {
        MapperIoUtils.BytesToResponseTransformer bytesToResponseTransformer;
        MapperIoUtils.RequestToBytesTransformer requestToBytesTransformer;
        MappingNatPmpRequest request;
        switch (portType) {
            case TCP: {
                request = new TcpMappingNatPmpRequest(internalPort, externalPort, lifetime);
                requestToBytesTransformer = new MapperIoUtils.RequestToBytesTransformer(){

                    @Override
                    public byte[] create(Object request) {
                        return ((TcpMappingNatPmpRequest)request).dump();
                    }
                };
                bytesToResponseTransformer = new MapperIoUtils.BytesToResponseTransformer(){

                    @Override
                    public Object create(byte[] buffer) {
                        TcpMappingNatPmpResponse resp = new TcpMappingNatPmpResponse(buffer);
                        if (resp.getResultCode() != NatPmpResultCode.SUCCESS.ordinal()) {
                            throw new IllegalArgumentException();
                        }
                        return resp;
                    }
                };
                break;
            }
            case UDP: {
                request = new UdpMappingNatPmpRequest(internalPort, externalPort, lifetime);
                requestToBytesTransformer = new MapperIoUtils.RequestToBytesTransformer(){

                    @Override
                    public byte[] create(Object request) {
                        return ((UdpMappingNatPmpRequest)request).dump();
                    }
                };
                bytesToResponseTransformer = new MapperIoUtils.BytesToResponseTransformer(){

                    @Override
                    public Object create(byte[] buffer) {
                        UdpMappingNatPmpResponse resp = new UdpMappingNatPmpResponse(buffer);
                        if (resp.getResultCode() != NatPmpResultCode.SUCCESS.ordinal()) {
                            throw new IllegalArgumentException();
                        }
                        return resp;
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        MapperIoUtils.UdpRequest mapIpReq = new MapperIoUtils.UdpRequest(internalAddress, new InetSocketAddress(gatewayAddress, 5351), request, requestToBytesTransformer, bytesToResponseTransformer);
        return mapIpReq;
    }

    @Override
    public InetAddress getSourceAddress() {
        return this.internalAddress;
    }

    public String toString() {
        return "NatPmpPortMapper{networkBus=" + this.networkBus + ", internalAddress=" + this.internalAddress + ", gatewayAddress=" + this.gatewayAddress + '}';
    }
}

