/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.NatPmpResponse;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Objects;

public final class ExternalAddressNatPmpResponse
extends NatPmpResponse {
    private static final int LENGTH = 12;
    private static final int OP = 128;
    private InetAddress inetAddress;

    public ExternalAddressNatPmpResponse(byte[] buffer) {
        super(buffer);
        Validate.notNull(buffer);
        Validate.isTrue(buffer.length == 12);
        Validate.isTrue(this.getOp() == 128);
        this.inetAddress = NetworkUtils.convertBytesToAddress(buffer, 8, 4);
        Validate.validState(this.inetAddress instanceof Inet4Address);
    }

    public ExternalAddressNatPmpResponse(int resultCode, long secondsSinceStartOfEpoch, InetAddress inetAddress) {
        super(128, resultCode, secondsSinceStartOfEpoch);
        Validate.notNull(inetAddress);
        Validate.isTrue(inetAddress instanceof Inet4Address);
        this.inetAddress = inetAddress;
    }

    @Override
    public byte[] dump() {
        byte[] data = new byte[12];
        data[0] = 0;
        data[1] = -128;
        InternalUtils.shortToBytes(data, 2, (short)this.getResultCode());
        InternalUtils.intToBytes(data, 4, (int)this.getSecondsSinceStartOfEpoch());
        byte[] addressBytes = this.inetAddress.getAddress();
        data[8] = addressBytes[0];
        data[9] = addressBytes[1];
        data[10] = addressBytes[2];
        data[11] = addressBytes[3];
        return data;
    }

    public InetAddress getAddress() {
        return this.inetAddress;
    }

    @Override
    public String toString() {
        return "ExternalAddressNatPmpResponse{super=" + super.toString() + "inetAddress=" + this.inetAddress + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 53 * hash + Objects.hashCode(this.inetAddress);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalAddressNatPmpResponse other = (ExternalAddressNatPmpResponse)obj;
        return Objects.equals(this.inetAddress, other.inetAddress);
    }
}

