/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.NatPmpRequest;

public abstract class MappingNatPmpRequest
extends NatPmpRequest {
    private static final int LENGTH = 12;
    private final int internalPort;
    private final int suggestedExternalPort;
    private final long lifetime;

    MappingNatPmpRequest(int expectedOp, byte[] buffer) {
        super(expectedOp);
        Validate.notNull(buffer);
        Validate.isTrue(buffer.length == 12);
        Validate.isTrue(this.getOp() == expectedOp);
        this.internalPort = InternalUtils.bytesToShort(buffer, 4) & 0xFFFF;
        this.suggestedExternalPort = InternalUtils.bytesToShort(buffer, 6) & 0xFFFF;
        this.lifetime = (long)InternalUtils.bytesToInt(buffer, 8) & 0xFFFFFFFFL;
        this.validateState();
    }

    MappingNatPmpRequest(int op, int internalPort, int suggestedExternalPort, long lifetime) {
        super(op);
        this.internalPort = internalPort;
        this.suggestedExternalPort = suggestedExternalPort;
        this.lifetime = lifetime;
        this.validateState();
    }

    private void validateState() {
        Validate.inclusiveBetween(1L, 65535L, this.internalPort);
        Validate.inclusiveBetween(0L, 65535L, this.suggestedExternalPort);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, this.lifetime);
    }

    @Override
    public final byte[] dump() {
        byte[] data = new byte[12];
        data[0] = 0;
        data[1] = (byte)this.getOp();
        data[2] = 0;
        data[3] = 0;
        InternalUtils.shortToBytes(data, 4, (short)this.internalPort);
        InternalUtils.shortToBytes(data, 6, (short)this.suggestedExternalPort);
        InternalUtils.intToBytes(data, 8, (int)this.lifetime);
        return data;
    }

    public final int getInternalPort() {
        return this.internalPort;
    }

    public final int getSuggestedExternalPort() {
        return this.suggestedExternalPort;
    }

    public final long getLifetime() {
        return this.lifetime;
    }

    @Override
    public String toString() {
        return "MappingNatPmpRequest{super=" + super.toString() + "internalPort=" + this.internalPort + ", suggestedExternalPort=" + this.suggestedExternalPort + ", lifetime=" + this.lifetime + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + this.internalPort;
        hash = 97 * hash + this.suggestedExternalPort;
        hash = 97 * hash + (int)(this.lifetime ^ this.lifetime >>> 32);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingNatPmpRequest other = (MappingNatPmpRequest)obj;
        if (this.internalPort != other.internalPort) {
            return false;
        }
        if (this.suggestedExternalPort != other.suggestedExternalPort) {
            return false;
        }
        return this.lifetime == other.lifetime;
    }
}

