/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.NatPmpResponse;

public abstract class MappingNatPmpResponse
extends NatPmpResponse {
    private static final int LENGTH = 16;
    private int internalPort;
    private int externalPort;
    private long lifetime;

    MappingNatPmpResponse(int expectedOp, byte[] buffer) {
        super(buffer);
        Validate.notNull(buffer);
        Validate.isTrue(buffer.length == 16);
        Validate.isTrue(this.getOp() == expectedOp);
        this.internalPort = InternalUtils.bytesToShort(buffer, 8) & 0xFFFF;
        this.externalPort = InternalUtils.bytesToShort(buffer, 10) & 0xFFFF;
        this.lifetime = (long)InternalUtils.bytesToInt(buffer, 12) & 0xFFFFFFFFL;
        this.validateState();
    }

    MappingNatPmpResponse(int op, int resultCode, long secondsSinceStartOfEpoch, int internalPort, int externalPort, long lifetime) {
        super(op, resultCode, secondsSinceStartOfEpoch);
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.lifetime = lifetime;
        this.validateState();
    }

    private void validateState() {
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, this.lifetime);
        Validate.inclusiveBetween(1L, 65535L, this.internalPort);
        if (this.lifetime != 0L) {
            Validate.inclusiveBetween(1L, 65535L, this.externalPort);
        }
    }

    @Override
    public final byte[] dump() {
        byte[] data = new byte[16];
        data[0] = 0;
        data[1] = (byte)this.getOp();
        InternalUtils.shortToBytes(data, 2, (short)this.getResultCode());
        InternalUtils.intToBytes(data, 4, (int)this.getSecondsSinceStartOfEpoch());
        InternalUtils.shortToBytes(data, 8, (short)this.internalPort);
        InternalUtils.shortToBytes(data, 10, (short)this.externalPort);
        InternalUtils.intToBytes(data, 12, (int)this.lifetime);
        return data;
    }

    public final int getInternalPort() {
        return this.internalPort;
    }

    public final int getExternalPort() {
        return this.externalPort;
    }

    public final long getLifetime() {
        return this.lifetime;
    }

    @Override
    public String toString() {
        return "MappingNatPmpResponse{super=" + super.toString() + "internalPort=" + this.internalPort + ", externalPort=" + this.externalPort + ", lifetime=" + this.lifetime + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + this.internalPort;
        hash = 97 * hash + this.externalPort;
        hash = 97 * hash + (int)(this.lifetime ^ this.lifetime >>> 32);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingNatPmpResponse other = (MappingNatPmpResponse)obj;
        if (this.internalPort != other.internalPort) {
            return false;
        }
        if (this.externalPort != other.externalPort) {
            return false;
        }
        return this.lifetime == other.lifetime;
    }
}

