/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.NatPmpMessage;

public abstract class NatPmpRequest
implements NatPmpMessage {
    private static final int HEADER_LENGTH = 2;
    private final int op;

    NatPmpRequest(int op) {
        this.op = op;
        this.validateState();
    }

    NatPmpRequest(byte[] buffer) {
        Validate.notNull(buffer);
        Validate.isTrue(buffer.length >= 2);
        int offset = 0;
        int version = buffer[offset] & 0xFF;
        Validate.isTrue(version == 0);
        this.op = buffer[++offset] & 0xFF;
        ++offset;
        this.validateState();
    }

    private void validateState() {
        Validate.inclusiveBetween(0L, 127L, this.op);
    }

    @Override
    public final int getOp() {
        return this.op;
    }

    public String toString() {
        return "NatPmpRequest{op=" + this.op + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.op;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NatPmpRequest other = (NatPmpRequest)obj;
        return this.op == other.op;
    }
}

