/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.natpmp.externalmessages.NatPmpMessage;

public abstract class NatPmpResponse
implements NatPmpMessage {
    private static final int HEADER_LENGTH = 8;
    private int op;
    private int resultCode;
    private long secondsSinceStartOfEpoch;

    NatPmpResponse(int op, int resultCode, long secondsSinceStartOfEpoch) {
        this.op = op;
        this.resultCode = resultCode;
        this.secondsSinceStartOfEpoch = secondsSinceStartOfEpoch;
        this.validateState();
    }

    NatPmpResponse(byte[] buffer) {
        Validate.notNull(buffer);
        Validate.isTrue(buffer.length >= 8);
        int offset = 0;
        int version = buffer[offset] & 0xFF;
        Validate.isTrue(version == 0);
        this.op = buffer[++offset] & 0xFF;
        this.resultCode = InternalUtils.bytesToShort(buffer, ++offset) & 0xFFFF;
        this.secondsSinceStartOfEpoch = (long)InternalUtils.bytesToInt(buffer, offset += 2) & 0xFFFFFFFFL;
        offset += 4;
        this.validateState();
    }

    private void validateState() {
        Validate.inclusiveBetween(128L, 255L, this.op);
        Validate.inclusiveBetween(0L, 65535L, this.resultCode);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, this.secondsSinceStartOfEpoch);
    }

    @Override
    public final int getOp() {
        return this.op;
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public final long getSecondsSinceStartOfEpoch() {
        return this.secondsSinceStartOfEpoch;
    }

    public String toString() {
        return "NatPmpResponse{op=" + this.op + ", resultCode=" + this.resultCode + ", secondsSinceStartOfEpoch=" + this.secondsSinceStartOfEpoch + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.op;
        hash = 83 * hash + this.resultCode;
        hash = 83 * hash + (int)(this.secondsSinceStartOfEpoch ^ this.secondsSinceStartOfEpoch >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NatPmpResponse other = (NatPmpResponse)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.resultCode != other.resultCode) {
            return false;
        }
        return this.secondsSinceStartOfEpoch == other.secondsSinceStartOfEpoch;
    }
}

